/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import com.seibel.distanthorizons.core.network.event.internal.IncompatibleMessageEvent;
import com.seibel.distanthorizons.core.network.event.internal.ProtocolErrorEvent;
import com.seibel.distanthorizons.core.network.messages.MessageRegistry;
import com.seibel.distanthorizons.core.network.messages.NetworkMessage;
import com.seibel.distanthorizons.core.network.messages.base.CloseReasonMessage;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.IPluginPacketSender;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.IServerPlayerWrapper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPluginPacketSender
implements IPluginPacketSender {
    private static final ConfigBasedLogger LOGGER = new ConfigBasedLogger(LogManager.getLogger(), () -> Config.Client.Advanced.Logging.logNetworkEvent.get());
    public static final class_2960 WRAPPER_PACKET_RESOURCE = class_2960.method_60655((String)"distant_horizons", (String)"message");

    @Override
    public final void sendPluginPacketServer(IServerPlayerWrapper serverPlayer, NetworkMessage message) {
        this.sendPluginPacketServer((class_3222)serverPlayer.getWrappedMcObject(), message);
    }

    @Override
    public abstract void sendPluginPacketClient(NetworkMessage var1);

    public abstract void sendPluginPacketServer(class_3222 var1, NetworkMessage var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static NetworkMessage decodeMessage(class_2540 in) {
        NetworkMessage message = null;
        try {
            in.method_52932();
            short protocolVersion = in.readShort();
            if (protocolVersion != 3) {
                IncompatibleMessageEvent incompatibleMessageEvent = new IncompatibleMessageEvent(protocolVersion);
                return incompatibleMessageEvent;
            }
            message = MessageRegistry.INSTANCE.createMessage(in.readUnsignedShort());
            message.decode((ByteBuf)in);
            if (in.isReadable()) {
                throw new IOException("Buffer has not been fully read");
            }
            NetworkMessage networkMessage = message;
            return networkMessage;
        }
        catch (Exception e) {
            in.method_52933();
            LOGGER.error("Failed to decode message", e);
            LOGGER.error("Buffer: {}", in);
            LOGGER.error("Buffer contents: [{}]", ByteBufUtil.hexDump((ByteBuf)in));
            ProtocolErrorEvent protocolErrorEvent = new ProtocolErrorEvent(e, message, true);
            return protocolErrorEvent;
        }
        finally {
            in.method_52988(in.writerIndex());
        }
    }

    public static void encodeMessage(class_2540 out, NetworkMessage message) {
        Objects.requireNonNull(message);
        out.method_52998(3);
        try {
            out.method_52934();
            out.method_52998(MessageRegistry.INSTANCE.getMessageId(message));
            message.encode((ByteBuf)out);
        }
        catch (Exception e) {
            LOGGER.error("Failed to encode message", e);
            LOGGER.error("Message: {}", message);
            message.getSession().tryHandleMessage(new ProtocolErrorEvent(e, message, false));
            out.method_52935();
            message = new CloseReasonMessage("Internal error on other side");
            out.method_52998(MessageRegistry.INSTANCE.getMessageId(message));
            message.encode((ByteBuf)out);
        }
    }
}

