/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiAfterDhInitEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeDhInitEvent;
import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.ConfigBase;
import com.seibel.distanthorizons.core.config.eventHandlers.presets.ThreadPresetConfigEventHandler;
import com.seibel.distanthorizons.core.config.types.AbstractConfigType;
import com.seibel.distanthorizons.core.config.types.ConfigEntry;
import com.seibel.distanthorizons.core.dependencyInjection.ModAccessorInjector;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.jar.ModJarInfo;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.network.messages.MessageRegistry;
import com.seibel.distanthorizons.core.network.messages.base.CodecCrashMessage;
import com.seibel.distanthorizons.core.util.objects.Pair;
import com.seibel.distanthorizons.core.world.DhServerWorld;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.IServerPlayerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IModAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IModChecker;
import com.seibel.distanthorizons.coreapi.DependencyInjection.ApiEventInjector;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.DependencySetup;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.minecraft.MinecraftDedicatedServerWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.misc.ServerPlayerWrapper;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3176;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Logger;

public abstract class AbstractModInitializer {
    protected static final Logger LOGGER = DhLoggerBuilder.getLogger(MethodHandles.lookup().lookupClass().getSimpleName());
    private CommandDispatcher<class_2168> commandDispatcher;

    protected abstract void createInitialBindings();

    protected abstract IEventProxy createClientProxy();

    protected abstract IEventProxy createServerProxy(boolean var1);

    protected abstract void initializeModCompat();

    protected abstract void subscribeRegisterCommandsEvent(Consumer<CommandDispatcher<class_2168>> var1);

    protected abstract void subscribeClientStartedEvent(Runnable var1);

    protected abstract void subscribeServerStartingEvent(Consumer<MinecraftServer> var1);

    protected abstract void runDelayedSetup();

    public void onInitializeClient() {
        DependencySetup.createClientBindings();
        LOGGER.info("Initializing Distant Horizons");
        ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeDhInitEvent.class, null);
        this.startup();
        this.printModInfo();
        this.createClientProxy().registerEvents();
        this.createServerProxy(false).registerEvents();
        this.initializeModCompat();
        LOGGER.info("Distant Horizons Initialized");
        ApiEventInjector.INSTANCE.fireAllEvents(DhApiAfterDhInitEvent.class, null);
        this.initConfig();
        this.subscribeClientStartedEvent(this::postInit);
    }

    public void onInitializeServer() {
        DependencySetup.createServerBindings();
        LOGGER.info("Initializing Distant Horizons");
        ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeDhInitEvent.class, null);
        this.startup();
        this.printModInfo();
        ThreadPresetConfigEventHandler.INSTANCE.toString();
        this.createServerProxy(true).registerEvents();
        this.initializeModCompat();
        LOGGER.info("Distant Horizons Initialized");
        ApiEventInjector.INSTANCE.fireAllEvents(DhApiAfterDhInitEvent.class, null);
        this.subscribeRegisterCommandsEvent(dispatcher -> {
            this.commandDispatcher = dispatcher;
        });
        this.subscribeServerStartingEvent(server -> {
            MinecraftDedicatedServerWrapper.INSTANCE.dedicatedServer = (class_3176)server;
            this.initConfig();
            this.postInit();
            this.initCommands();
            LOGGER.info("Dedicated server initialized at " + String.valueOf(server.method_3831()));
        });
    }

    private void startup() {
        DependencySetup.createSharedBindings();
        SharedApi.init();
        this.createInitialBindings();
    }

    private void printModInfo() {
        LOGGER.info("Distant Horizons, Version: 2.2.2-a-dev");
        LOGGER.info("DH Branch: " + ModJarInfo.Git_Branch);
        LOGGER.info("DH Commit: " + ModJarInfo.Git_Commit);
        LOGGER.info("DH Jar Build Source: " + ModJarInfo.Build_Source);
    }

    protected <T extends IModAccessor> void tryCreateModCompatAccessor(String modId, Class<? super T> accessorClass, Supplier<T> accessorConstructor) {
        IModChecker modChecker = SingletonInjector.INSTANCE.get(IModChecker.class);
        if (modChecker.isModLoaded(modId)) {
            ModAccessorInjector.INSTANCE.bind(accessorClass, (IModAccessor)accessorConstructor.get());
        }
    }

    private void initConfig() {
        ConfigBase.INSTANCE = new ConfigBase("distanthorizons", "DistantHorizons", Config.class, 2);
        Config.completeDelayedSetup();
    }

    private void postInit() {
        LOGGER.info("Post-Initializing Mod");
        this.runDelayedSetup();
        LOGGER.info("Mod Post-Initialized");
    }

    private void initCommands() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)class_2170.method_9247((String)"dhconfig").requires(source -> source.method_9259(4));
        for (AbstractConfigType<?, ?> type2 : ConfigBase.INSTANCE.entries) {
            ConfigEntry configEntry;
            if (!(type2 instanceof ConfigEntry) || (configEntry = (ConfigEntry)type2).getServersideShortName() == null) continue;
            Function<Function, Command> makeConfigUpdater = getter -> c -> {
                Object value = getter.apply(c);
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)("Changed the value of " + configEntry.getServersideShortName() + " to " + String.valueOf(value))), true);
                configEntry.set(value);
                return 1;
            };
            LiteralArgumentBuilder subcommand = (LiteralArgumentBuilder)class_2170.method_9247((String)configEntry.getServersideShortName()).executes(c -> {
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)("Current value of " + configEntry.getServersideShortName() + " is " + String.valueOf(configEntry.get()))), true);
                return 1;
            });
            if (Enum.class.isAssignableFrom(configEntry.getType())) {
                for (Object choice : configEntry.getType().getEnumConstants()) {
                    subcommand.then(class_2170.method_9247((String)choice.toString()).executes(makeConfigUpdater.apply(c -> choice)));
                }
            } else {
                boolean setterAdded = false;
                for (Map.Entry pair : new HashMap<Class<?>, Pair<Supplier<ArgumentType<?>>, BiFunction<CommandContext<?>, String, ?>>>(){
                    {
                        this.put(Integer.class, new Pair<Supplier<ArgumentType>, BiFunction<CommandContext, String, Object>>(() -> IntegerArgumentType.integer((int)((Integer)configEntry.getMin()), (int)((Integer)configEntry.getMax())), IntegerArgumentType::getInteger));
                        this.put(Double.class, new Pair<Supplier<ArgumentType>, BiFunction<CommandContext, String, Object>>(() -> DoubleArgumentType.doubleArg((double)((Double)configEntry.getMin()), (double)((Double)configEntry.getMax())), DoubleArgumentType::getDouble));
                        this.put(Boolean.class, new Pair<Supplier<ArgumentType>, BiFunction<CommandContext, String, Object>>(BoolArgumentType::bool, BoolArgumentType::getBool));
                        this.put(String.class, new Pair<Supplier<ArgumentType>, BiFunction<CommandContext, String, Object>>(StringArgumentType::string, StringArgumentType::getString));
                    }
                }.entrySet()) {
                    if (!((Class)pair.getKey()).isAssignableFrom(configEntry.getType())) continue;
                    subcommand.then(class_2170.method_9244((String)"value", (ArgumentType)((ArgumentType)((Supplier)((Pair)pair.getValue()).first).get())).executes(makeConfigUpdater.apply(c -> ((BiFunction)((Pair)pair.getValue()).second).apply(c, "value"))));
                    setterAdded = true;
                    break;
                }
                if (!setterAdded) {
                    throw new RuntimeException("Config type of " + type2.getName() + " is not supported: " + configEntry.getType().getSimpleName());
                }
            }
            builder.then((ArgumentBuilder)subcommand);
        }
        this.commandDispatcher.register(builder);
        if (MessageRegistry.DEBUG_ENABLE_CODEC_CRASH_MESSAGE) {
            LiteralArgumentBuilder dhcrash = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"dhcrash").requires(source -> source.method_9259(4))).then(class_2170.method_9247((String)"encode").executes(c -> {
                assert (SharedApi.getIDhServerWorld() != null);
                ((DhServerWorld)SharedApi.getIDhServerWorld()).remotePlayerConnectionHandler.getConnectedPlayer((IServerPlayerWrapper)ServerPlayerWrapper.getWrapper((class_3222)Objects.requireNonNull(((class_2168)c.getSource()).method_44023()))).session.sendMessage(new CodecCrashMessage(CodecCrashMessage.ECrashPhase.ENCODE));
                return 1;
            }))).then(class_2170.method_9247((String)"decode").executes(c -> {
                assert (SharedApi.getIDhServerWorld() != null);
                ((DhServerWorld)SharedApi.getIDhServerWorld()).remotePlayerConnectionHandler.getConnectedPlayer((IServerPlayerWrapper)ServerPlayerWrapper.getWrapper((class_3222)Objects.requireNonNull(((class_2168)c.getSource()).method_44023()))).session.sendMessage(new CodecCrashMessage(CodecCrashMessage.ECrashPhase.DECODE));
                return 1;
            }));
            this.commandDispatcher.register(dhcrash);
        }
    }

    public static interface IEventProxy {
        public void registerEvents();
    }
}

