/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.world;

import com.seibel.distanthorizons.core.file.structure.LocalSaveStructure;
import com.seibel.distanthorizons.core.level.DhServerLevel;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.multiplayer.server.RemotePlayerConnectionHandler;
import com.seibel.distanthorizons.core.multiplayer.server.ServerPlayerState;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.world.AbstractDhWorld;
import com.seibel.distanthorizons.core.world.EWorldEnvironment;
import com.seibel.distanthorizons.core.world.IDhServerWorld;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.IServerPlayerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import java.io.File;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class DhServerWorld
extends AbstractDhWorld
implements IDhServerWorld {
    private final HashMap<IServerLevelWrapper, DhServerLevel> levels;
    public final LocalSaveStructure saveStructure = new LocalSaveStructure();
    public final RemotePlayerConnectionHandler remotePlayerConnectionHandler;

    public DhServerWorld() {
        super(EWorldEnvironment.Server_Only);
        this.levels = new HashMap();
        this.remotePlayerConnectionHandler = new RemotePlayerConnectionHandler();
        LOGGER.info("Started " + DhServerWorld.class.getSimpleName() + " of type " + (Object)((Object)this.environment));
    }

    public void addPlayer(IServerPlayerWrapper serverPlayer) {
        ServerPlayerState playerState = this.remotePlayerConnectionHandler.registerJoinedPlayer(serverPlayer);
        this.getLevel(serverPlayer.getLevel()).addPlayer(serverPlayer);
        for (DhServerLevel level : this.levels.values()) {
            level.registerNetworkHandlers(playerState);
        }
    }

    public void removePlayer(IServerPlayerWrapper serverPlayer) {
        this.getLevel(serverPlayer.getLevel()).removePlayer(serverPlayer);
        this.remotePlayerConnectionHandler.unregisterLeftPlayer(serverPlayer);
    }

    public void changePlayerLevel(IServerPlayerWrapper player, IServerLevelWrapper origin, IServerLevelWrapper dest) {
        this.getLevel(dest).addPlayer(player);
        this.getLevel(origin).removePlayer(player);
    }

    @Override
    public DhServerLevel getOrLoadLevel(@NotNull ILevelWrapper wrapper) {
        if (!(wrapper instanceof IServerLevelWrapper)) {
            return null;
        }
        return this.levels.computeIfAbsent((IServerLevelWrapper)wrapper, serverLevelWrapper -> {
            File levelFile = this.saveStructure.getLevelFolder(wrapper);
            LodUtil.assertTrue(levelFile != null);
            return new DhServerLevel(this.saveStructure, (IServerLevelWrapper)serverLevelWrapper, this.remotePlayerConnectionHandler);
        });
    }

    @Override
    public DhServerLevel getLevel(@NotNull ILevelWrapper wrapper) {
        if (!(wrapper instanceof IServerLevelWrapper)) {
            return null;
        }
        return this.levels.get(wrapper);
    }

    @Override
    public Iterable<? extends IDhLevel> getAllLoadedLevels() {
        return this.levels.values();
    }

    @Override
    public int getLoadedLevelCount() {
        return this.levels.size();
    }

    @Override
    public void unloadLevel(@NotNull ILevelWrapper wrapper) {
        if (!(wrapper instanceof IServerLevelWrapper)) {
            return;
        }
        if (this.levels.containsKey(wrapper)) {
            LOGGER.info("Unloading level {} ", (Object)this.levels.get(wrapper));
            wrapper.onUnload();
            this.levels.remove(wrapper).close();
        }
    }

    @Override
    public void serverTick() {
        this.levels.values().forEach(DhServerLevel::serverTick);
    }

    @Override
    public void doWorldGen() {
        this.levels.values().forEach(DhServerLevel::doWorldGen);
    }

    @Override
    public void close() {
        for (DhServerLevel level : this.levels.values()) {
            LOGGER.info("Unloading level " + level.getLevelWrapper().getDimensionName());
            IServerLevelWrapper serverLevelWrapper = level.getServerLevelWrapper();
            if (serverLevelWrapper != null) {
                serverLevelWrapper.onUnload();
            }
            level.close();
        }
        this.levels.clear();
        LOGGER.info("Closed DhWorld of type " + (Object)((Object)this.environment));
    }
}

