/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.world;

import com.seibel.distanthorizons.api.interfaces.world.IDhApiDimensionTypeWrapper;
import com.seibel.distanthorizons.api.interfaces.world.IDhApiLevelWrapper;
import com.seibel.distanthorizons.api.interfaces.world.IDhApiWorldProxy;
import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.world.AbstractDhWorld;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftSharedWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.util.ArrayList;

public class DhApiWorldProxy
implements IDhApiWorldProxy {
    public static DhApiWorldProxy INSTANCE = new DhApiWorldProxy();
    private static final IMinecraftClientWrapper MC_CLIENT = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static final IMinecraftSharedWrapper MC_SHARED = SingletonInjector.INSTANCE.get(IMinecraftSharedWrapper.class);
    private static final String NO_WORLD_EXCEPTION_STRING = "No world loaded";

    private DhApiWorldProxy() {
    }

    @Override
    public boolean worldLoaded() {
        return SharedApi.getAbstractDhWorld() != null;
    }

    @Override
    public IDhApiLevelWrapper getSinglePlayerLevel() {
        if (SharedApi.getAbstractDhWorld() == null) {
            throw new IllegalStateException(NO_WORLD_EXCEPTION_STRING);
        }
        if (!MC_SHARED.isDedicatedServer()) {
            return MC_CLIENT.getWrappedClientLevel();
        }
        return null;
    }

    @Override
    public Iterable<IDhApiLevelWrapper> getAllLoadedLevelWrappers() {
        AbstractDhWorld world = SharedApi.getAbstractDhWorld();
        if (world == null) {
            throw new IllegalStateException(NO_WORLD_EXCEPTION_STRING);
        }
        ArrayList<IDhApiLevelWrapper> returnList = new ArrayList<IDhApiLevelWrapper>();
        for (IDhLevel iDhLevel : world.getAllLoadedLevels()) {
            returnList.add(iDhLevel.getLevelWrapper());
        }
        return returnList;
    }

    @Override
    public Iterable<IDhApiLevelWrapper> getAllLoadedLevelsForDimensionType(IDhApiDimensionTypeWrapper dimensionTypeWrapper) {
        AbstractDhWorld world = SharedApi.getAbstractDhWorld();
        if (world == null) {
            throw new IllegalStateException(NO_WORLD_EXCEPTION_STRING);
        }
        ArrayList<IDhApiLevelWrapper> returnList = new ArrayList<IDhApiLevelWrapper>();
        for (IDhLevel iDhLevel : world.getAllLoadedLevels()) {
            ILevelWrapper levelWrapper = iDhLevel.getLevelWrapper();
            if (!levelWrapper.getDimensionType().equals(dimensionTypeWrapper)) continue;
            returnList.add(levelWrapper);
        }
        return returnList;
    }

    @Override
    public Iterable<IDhApiLevelWrapper> getAllLoadedLevelsWithDimensionNameLike(String dimensionName) {
        AbstractDhWorld world = SharedApi.getAbstractDhWorld();
        if (world == null) {
            throw new IllegalStateException(NO_WORLD_EXCEPTION_STRING);
        }
        String soughtDimName = dimensionName.toLowerCase();
        ArrayList<IDhApiLevelWrapper> returnList = new ArrayList<IDhApiLevelWrapper>();
        for (IDhLevel iDhLevel : world.getAllLoadedLevels()) {
            ILevelWrapper levelWrapper = iDhLevel.getLevelWrapper();
            String levelDimName = levelWrapper.getDimensionName().toLowerCase();
            if (!levelDimName.contains(soughtDimName)) continue;
            returnList.add(levelWrapper);
        }
        return returnList;
    }
}

