/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util.ratelimiting;

import com.google.common.util.concurrent.RateLimiter;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class SupplierBasedRateLimiter<T> {
    private final Supplier<Integer> maxRateSupplier;
    private final Consumer<T> onFailureConsumer;
    private final RateLimiter rateLimiter = RateLimiter.create((double)Double.POSITIVE_INFINITY);

    public SupplierBasedRateLimiter(Supplier<Integer> maxRateSupplier) {
        this(maxRateSupplier, ignored -> {});
    }

    public SupplierBasedRateLimiter(Supplier<Integer> maxRateSupplier, Consumer<T> onFailureConsumer) {
        this.maxRateSupplier = maxRateSupplier;
        this.onFailureConsumer = onFailureConsumer;
    }

    public boolean tryAcquire(T context) {
        return this.tryAcquire(context, 1);
    }

    public boolean tryAcquire() {
        return this.tryAcquire(null, 1);
    }

    public int acquireOrDrain(int permits) {
        this.rateLimiter.setRate((double)this.maxRateSupplier.get().intValue());
        int acquired = 0;
        while (permits > 0 && this.rateLimiter.tryAcquire()) {
            ++acquired;
            --permits;
        }
        return acquired;
    }

    public boolean tryAcquire(T context, int permits) {
        this.rateLimiter.setRate((double)this.maxRateSupplier.get().intValue());
        if (!this.rateLimiter.tryAcquire(permits)) {
            this.onFailureConsumer.accept(context);
            return false;
        }
        return true;
    }
}

