/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util.ratelimiting;

import com.seibel.distanthorizons.core.util.ratelimiting.SupplierBasedConcurrencyLimiter;
import com.seibel.distanthorizons.core.util.ratelimiting.SupplierBasedRateLimiter;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class SupplierBasedRateAndConcurrencyLimiter<T> {
    private final SupplierBasedRateLimiter<T> rateLimiter;
    private final SupplierBasedConcurrencyLimiter<T> concurrencyLimiter;

    public SupplierBasedRateAndConcurrencyLimiter(Supplier<Integer> maxRateSupplier, Consumer<T> onFailureConsumer) {
        this.rateLimiter = new SupplierBasedRateLimiter<T>(maxRateSupplier, onFailureConsumer);
        this.concurrencyLimiter = new SupplierBasedConcurrencyLimiter<T>(maxRateSupplier, onFailureConsumer);
    }

    public boolean tryAcquire(T context) {
        if (!this.concurrencyLimiter.tryAcquire(context)) {
            return false;
        }
        if (!this.rateLimiter.tryAcquire(context)) {
            this.concurrencyLimiter.release();
            return false;
        }
        return true;
    }

    public void release() {
        this.concurrencyLimiter.release();
    }
}

