/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.sql.repo;

import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.sql.DatabaseUpdater;
import com.seibel.distanthorizons.core.sql.DbConnectionClosedException;
import com.seibel.distanthorizons.core.sql.dto.IBaseDTO;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDhRepo<TKey, TDTO extends IBaseDTO<TKey>>
implements AutoCloseable {
    public static final int TIMEOUT_SECONDS = 0;
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final ConcurrentHashMap<String, Connection> CONNECTIONS_BY_CONNECTION_STRING = new ConcurrentHashMap();
    private static final ConcurrentHashMap<AbstractDhRepo<?, ?>, String> ACTIVE_CONNECTION_STRINGS_BY_REPO = new ConcurrentHashMap();
    private final String connectionString;
    private final Connection connection;
    public final String databaseType;
    public final File databaseFile;
    public final Class<? extends TDTO> dtoClass;
    protected final ReentrantLock[] saveLockArray;

    protected ReentrantLock getSaveLockForKey(TKey key) {
        return this.saveLockArray[Math.abs(key.hashCode()) % this.saveLockArray.length];
    }

    public AbstractDhRepo(String databaseType, File databaseFile, Class<? extends TDTO> dtoClass) throws SQLException {
        this.databaseType = databaseType;
        this.databaseFile = databaseFile;
        this.dtoClass = dtoClass;
        int lockCount = Runtime.getRuntime().availableProcessors() * 2;
        this.saveLockArray = new ReentrantLock[lockCount];
        for (int i = 0; i < lockCount; ++i) {
            this.saveLockArray[i] = new ReentrantLock();
        }
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (!databaseFile.exists()) {
            File parentFolder = databaseFile.getParentFile();
            if (parentFolder != null && !parentFolder.exists() && !parentFolder.mkdirs()) {
                throw new RuntimeException("Unable to create the necessary parent folders for the database file at location [" + databaseFile.getPath() + "].");
            }
            if (!databaseFile.exists()) {
                try {
                    boolean bl = databaseFile.createNewFile();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to create database file at location [" + databaseFile.getPath() + "] due to error: [" + e.getMessage() + "]", e);
                }
            }
        }
        if (!databaseFile.canRead()) {
            throw new RuntimeException("Unable to read database file at location [" + databaseFile.getPath() + "], please make sure the folder and file has the correct permissions.");
        }
        if (!databaseFile.canWrite()) {
            throw new RuntimeException("Unable to write database file at location [" + databaseFile.getPath() + "], please make sure the folder and file aren't set to read-only.");
        }
        this.connectionString = this.databaseType + ":" + this.databaseFile.getPath();
        this.connection = CONNECTIONS_BY_CONNECTION_STRING.computeIfAbsent(this.connectionString, connectionString -> {
            try {
                return DriverManager.getConnection(connectionString);
            }
            catch (SQLException e) {
                LOGGER.error("Unable to connect to database with the connection string: [" + connectionString + "]");
                return null;
            }
        });
        if (this.connection == null) {
            throw new SQLException("Unable to get repo with connection string [" + this.connectionString + "]");
        }
        ACTIVE_CONNECTION_STRINGS_BY_REPO.put(this, this.connectionString);
        DatabaseUpdater.runAutoUpdateScripts(this);
    }

    public TDTO getByKey(TKey primaryKey) {
        Map<String, Object> objectMap = this.queryDictionaryFirst(this.createSelectByKeySql(primaryKey));
        if (objectMap != null && !objectMap.isEmpty()) {
            return this.convertDictionaryToDto(objectMap);
        }
        return null;
    }

    public void save(TDTO dto) {
        ReentrantLock saveLock = this.getSaveLockForKey(dto.getKey());
        try {
            saveLock.lock();
            if (this.existsWithKey(dto.getKey())) {
                this.update(dto);
            } else {
                this.insert(dto);
            }
        }
        finally {
            saveLock.unlock();
        }
    }

    private void insert(TDTO dto) {
        try (PreparedStatement statement = this.createInsertStatement(dto);){
            this.query(statement);
        }
        catch (DbConnectionClosedException ignored) {
            LOGGER.warn("Attempted to insert [" + this.dtoClass.getSimpleName() + "] with primary key [" + (dto != null ? dto.getKeyDisplayString() : "NULL") + "] on closed repo [" + this.connectionString + "].");
        }
        catch (SQLException e) {
            String message = "Unexpected insert statement error: [" + e.getMessage() + "].";
            LOGGER.error(message);
            throw new RuntimeException(message, e);
        }
    }

    private void update(TDTO dto) {
        try (PreparedStatement statement = this.createUpdateStatement(dto);){
            this.query(statement);
        }
        catch (DbConnectionClosedException e) {
            LOGGER.warn("Attempted to update [" + this.dtoClass.getSimpleName() + "] with primary key [" + (dto != null ? dto.getKeyDisplayString() : "NULL") + "] on closed repo [" + this.connectionString + "].");
        }
        catch (SQLException e) {
            String message = "Unexpected update statement error: [" + e.getMessage() + "].";
            LOGGER.error(message);
            throw new RuntimeException(message, e);
        }
    }

    public void delete(TDTO dto) {
        this.deleteWithKey(dto.getKey());
    }

    public void deleteWithKey(TKey key) {
        String whereEqualStatement = this.createWhereStatement(key);
        this.queryDictionaryFirst("DELETE FROM " + this.getTableName() + " WHERE " + whereEqualStatement);
    }

    public void deleteAll() {
        this.queryDictionaryFirst("DELETE FROM " + this.getTableName());
    }

    public boolean exists(TDTO dto) {
        return this.existsWithKey(dto.getKey());
    }

    public boolean existsWithKey(TKey key) {
        String whereEqualStatement = this.createWhereStatement(key);
        Map<String, Object> result = this.queryDictionaryFirst("SELECT EXISTS(SELECT 1 FROM " + this.getTableName() + " WHERE " + whereEqualStatement + ") as 'existingCount';");
        return result != null && (Integer)result.get("existingCount") != 0;
    }

    public List<Map<String, Object>> queryDictionary(String sql) {
        try {
            return this.query(sql);
        }
        catch (DbConnectionClosedException e) {
            return new ArrayList<Map<String, Object>>();
        }
    }

    @Nullable
    public Map<String, Object> queryDictionaryFirst(String sql) {
        try {
            List<Map<String, Object>> objectList = this.query(sql);
            return !objectList.isEmpty() ? objectList.get(0) : null;
        }
        catch (DbConnectionClosedException e) {
            return null;
        }
    }

    public List<Map<String, Object>> query(PreparedStatement statement) throws RuntimeException, DbConnectionClosedException {
        List<Map<String, Object>> list;
        block9: {
            statement.setQueryTimeout(0);
            boolean resultSetPresent = statement.execute();
            ResultSet resultSet = statement.getResultSet();
            try {
                list = this.parseQueryResult(resultSet, resultSetPresent);
                if (resultSet == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    if (DbConnectionClosedException.IsClosedException(e)) {
                        throw new DbConnectionClosedException(e);
                    }
                    String message = "Unexpected Query error: [" + e.getMessage() + "], for prepared statement: [" + statement + "].";
                    LOGGER.error(message);
                    throw new RuntimeException(message, e);
                }
            }
            resultSet.close();
        }
        return list;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<Map<String, Object>> query(String sql) throws RuntimeException, DbConnectionClosedException {
        try (Statement statement = this.connection.createStatement();){
            List<Map<String, Object>> list;
            block15: {
                statement.setQueryTimeout(0);
                boolean resultSetPresent = statement.execute(sql);
                ResultSet resultSet = statement.getResultSet();
                try {
                    list = this.parseQueryResult(resultSet, resultSetPresent);
                    if (resultSet == null) break block15;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return list;
        }
        catch (SQLException e) {
            if (DbConnectionClosedException.IsClosedException(e)) {
                throw new DbConnectionClosedException(e);
            }
            String message = "Unexpected Query error: [" + e.getMessage() + "], for script: [" + sql + "].";
            LOGGER.error(message);
            throw new RuntimeException(message, e);
        }
    }

    private List<Map<String, Object>> parseQueryResult(ResultSet resultSet, boolean resultSetPresent) throws SQLException {
        if (resultSetPresent) {
            List<Map<String, Object>> resultList = AbstractDhRepo.convertResultSetToDictionaryList(resultSet);
            resultSet.close();
            return resultList;
        }
        if (resultSet != null) {
            resultSet.close();
        }
        return new ArrayList<Map<String, Object>>();
    }

    public PreparedStatement createPreparedStatement(String sql) throws DbConnectionClosedException {
        try {
            PreparedStatement statement = this.connection.prepareStatement(sql);
            statement.setQueryTimeout(0);
            return statement;
        }
        catch (SQLException e) {
            if (DbConnectionClosedException.IsClosedException(e)) {
                throw new DbConnectionClosedException(e);
            }
            String message = "Unexpected error: [" + e.getMessage() + "], preparing statement: [" + sql + "].";
            LOGGER.error(message);
            throw new RuntimeException(message, e);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean isConnected() {
        try {
            return this.connection != null && this.connection.isClosed();
        }
        catch (SQLException e) {
            return false;
        }
    }

    public static void closeAllConnections() {
        LOGGER.info("Closing all [" + ACTIVE_CONNECTION_STRINGS_BY_REPO.size() + "] database connections...");
        for (String connectionString : ACTIVE_CONNECTION_STRINGS_BY_REPO.values()) {
            try {
                Connection connection = CONNECTIONS_BY_CONNECTION_STRING.remove(connectionString);
                if (connection == null) continue;
                if (!connection.isClosed()) {
                    LOGGER.info("Closing database connection: [" + connectionString + "]");
                    connection.close();
                    continue;
                }
                LOGGER.warn("Attempting to close already closed database connection: [" + connectionString + "]");
            }
            catch (SQLException e) {
                LOGGER.error("Unable to close the connection [" + connectionString + "], error: [" + e.getMessage() + "]");
            }
        }
    }

    @Override
    public void close() {
        try {
            ACTIVE_CONNECTION_STRINGS_BY_REPO.remove(this);
            if (!ACTIVE_CONNECTION_STRINGS_BY_REPO.containsValue(this.connectionString)) {
                if (this.connection != null) {
                    CONNECTIONS_BY_CONNECTION_STRING.remove(this.connectionString);
                    if (!this.connection.isClosed()) {
                        LOGGER.info("Closing database connection: [" + this.connectionString + "]");
                        this.connection.close();
                    } else {
                        LOGGER.warn("Attempting to close already closed database connection: [" + this.connectionString + "]");
                    }
                }
                ACTIVE_CONNECTION_STRINGS_BY_REPO.remove(this);
            }
        }
        catch (SQLException e) {
            LOGGER.error("Unable to close the connection [" + this.connectionString + "], error: [" + e.getMessage() + "]");
        }
    }

    public String createWhereStatement(TDTO dto) {
        return this.createWhereStatement((TKey)dto.getKey());
    }

    public static List<Map<String, Object>> convertResultSetToDictionaryList(ResultSet resultSet) throws SQLException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        ResultSetMetaData resultMetaData = resultSet.getMetaData();
        int resultColumnCount = resultMetaData.getColumnCount();
        while (resultSet.next()) {
            HashMap<String, Object> object = new HashMap<String, Object>();
            for (int columnIndex = 1; columnIndex <= resultColumnCount; ++columnIndex) {
                Object columnValue;
                String columnType;
                String columnName = resultMetaData.getColumnName(columnIndex);
                if (columnName == null || columnName.equals("")) {
                    throw new RuntimeException("SQL result set is missing a column name for column [" + resultMetaData.getTableName(columnIndex) + "." + columnIndex + "].");
                }
                switch (columnType = resultMetaData.getColumnTypeName(columnIndex).toUpperCase()) {
                    case "BIGINT": {
                        columnValue = resultSet.getLong(columnIndex);
                        break;
                    }
                    case "SMALLINT": {
                        columnValue = resultSet.getShort(columnIndex);
                        break;
                    }
                    case "TINYINT": {
                        columnValue = resultSet.getByte(columnIndex);
                        break;
                    }
                    default: {
                        columnValue = resultSet.getObject(columnIndex);
                    }
                }
                object.put(columnName, columnValue);
            }
            list.add(object);
        }
        return list;
    }

    public abstract String getTableName();

    @Nullable
    public abstract TDTO convertDictionaryToDto(Map<String, Object> var1) throws ClassCastException;

    public String createSelectByKeySql(TKey key) {
        return "SELECT * FROM " + this.getTableName() + " WHERE " + this.createWhereStatement(key);
    }

    public abstract String createWhereStatement(TKey var1);

    public abstract PreparedStatement createInsertStatement(TDTO var1) throws SQLException;

    public abstract PreparedStatement createUpdateStatement(TDTO var1) throws SQLException;
}

