/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.renderer;

import com.seibel.distanthorizons.api.enums.config.EDhApiGpuUploadMethod;
import com.seibel.distanthorizons.api.enums.config.EDhApiLoggerMode;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.types.ConfigEntry;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import com.seibel.distanthorizons.core.logging.ConfigBasedSpamLogger;
import com.seibel.distanthorizons.core.pos.DhLodPos;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.render.glObject.GLState;
import com.seibel.distanthorizons.core.render.glObject.buffer.GLElementBuffer;
import com.seibel.distanthorizons.core.render.glObject.buffer.GLVertexBuffer;
import com.seibel.distanthorizons.core.render.glObject.shader.ShaderProgram;
import com.seibel.distanthorizons.core.render.glObject.vertexAttribute.AbstractVertexAttribute;
import com.seibel.distanthorizons.core.render.glObject.vertexAttribute.VertexPointer;
import com.seibel.distanthorizons.core.render.renderer.IDebugRenderable;
import com.seibel.distanthorizons.core.render.renderer.TestRenderer;
import com.seibel.distanthorizons.core.util.math.Mat4f;
import com.seibel.distanthorizons.core.util.math.Vec3d;
import com.seibel.distanthorizons.core.util.math.Vec3f;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import java.awt.Color;
import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL32;

public class DebugRenderer {
    public static DebugRenderer INSTANCE = new DebugRenderer();
    public static final ConfigBasedLogger LOGGER = new ConfigBasedLogger(LogManager.getLogger(TestRenderer.class), () -> EDhApiLoggerMode.LOG_ALL_TO_CHAT);
    public static final ConfigBasedSpamLogger SPAM_LOGGER = new ConfigBasedSpamLogger(LogManager.getLogger(TestRenderer.class), () -> EDhApiLoggerMode.LOG_ALL_TO_CHAT, 1);
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);
    private ShaderProgram basicShader;
    private GLVertexBuffer vertexBuffer;
    private GLElementBuffer outlineIndexBuffer;
    private AbstractVertexAttribute va;
    private boolean init = false;
    private Mat4f transformationMatrixThisFrame;
    private Vec3f camPosFloatThisFrame;
    private final RendererLists rendererLists = new RendererLists();
    private final PriorityBlockingQueue<BoxParticle> particles = new PriorityBlockingQueue();
    private static final float[] BOX_VERTICES = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    private static final int[] BOX_OUTLINE_INDICES = new int[]{0, 1, 1, 2, 2, 3, 3, 0, 4, 5, 5, 6, 6, 7, 7, 4, 0, 4, 1, 5, 2, 6, 3, 7};

    private DebugRenderer() {
    }

    public void init() {
        if (this.init) {
            return;
        }
        this.init = true;
        this.va = AbstractVertexAttribute.create();
        this.va.bind();
        this.va.setVertexAttribute(0, 0, VertexPointer.addVec3Pointer(false));
        this.va.completeAndCheck(12);
        this.basicShader = new ShaderProgram("shaders/debug/vert.vert", "shaders/debug/frag.frag", "fragColor", new String[]{"vPosition"});
        this.createBuffer();
    }

    private void createBuffer() {
        ByteBuffer boxVerticesBuffer = ByteBuffer.allocateDirect(BOX_VERTICES.length * 4);
        boxVerticesBuffer.order(ByteOrder.nativeOrder());
        boxVerticesBuffer.asFloatBuffer().put(BOX_VERTICES);
        boxVerticesBuffer.rewind();
        this.vertexBuffer = new GLVertexBuffer(false);
        this.vertexBuffer.bind();
        this.vertexBuffer.uploadBuffer(boxVerticesBuffer, 8, EDhApiGpuUploadMethod.DATA, BOX_VERTICES.length * 4);
        ByteBuffer boxOutlineBuffer = ByteBuffer.allocateDirect(BOX_OUTLINE_INDICES.length * 4);
        boxOutlineBuffer.order(ByteOrder.nativeOrder());
        boxOutlineBuffer.asIntBuffer().put(BOX_OUTLINE_INDICES);
        boxOutlineBuffer.rewind();
        this.outlineIndexBuffer = new GLElementBuffer(false);
        this.outlineIndexBuffer.uploadBuffer(boxOutlineBuffer, EDhApiGpuUploadMethod.DATA, BOX_OUTLINE_INDICES.length * 4, 35044);
    }

    public static void makeParticle(BoxParticle particle) {
        if (INSTANCE != null && Config.Client.Advanced.Debugging.DebugWireframe.enableRendering.get().booleanValue()) {
            DebugRenderer.INSTANCE.particles.add(particle);
        }
    }

    public static void register(IDebugRenderable renderable, ConfigEntry<Boolean> config) {
        if (INSTANCE != null) {
            INSTANCE.addRenderer(renderable, config);
        }
    }

    public void addRenderer(IDebugRenderable renderable, ConfigEntry<Boolean> config) {
        this.rendererLists.addRenderable(renderable, config);
    }

    public static void unregister(IDebugRenderable renderable, ConfigEntry<Boolean> config) {
        if (INSTANCE != null) {
            INSTANCE.removeRenderer(renderable, config);
        }
    }

    private void removeRenderer(IDebugRenderable renderable, ConfigEntry<Boolean> config) {
        this.rendererLists.removeRenderable(renderable, config);
    }

    public static void clearRenderables() {
        DebugRenderer.INSTANCE.rendererLists.clearRenderables();
    }

    public void render(Mat4f transform) {
        this.transformationMatrixThisFrame = transform;
        Vec3d camPos = MC_RENDER.getCameraExactPosition();
        this.camPosFloatThisFrame = new Vec3f((float)camPos.x, (float)camPos.y, (float)camPos.z);
        GLState glState = new GLState();
        this.init();
        GL32.glPolygonMode((int)1032, (int)6913);
        GL32.glEnable((int)2929);
        this.basicShader.bind();
        this.va.bind();
        this.va.bindBufferToAllBindingPoints(this.vertexBuffer.getId());
        this.outlineIndexBuffer.bind();
        this.rendererLists.render(this);
        BoxParticle head = null;
        while ((head = this.particles.poll()) != null && head.isDead(System.nanoTime())) {
        }
        if (head != null) {
            this.particles.add(head);
        }
        GL32.glPolygonMode((int)1032, (int)6914);
        for (BoxParticle particle : this.particles) {
            this.renderBox(particle.getBox());
        }
        glState.restore();
    }

    public void renderBox(Box box) {
        Mat4f boxTransform = Mat4f.createTranslateMatrix(box.minPos.x - this.camPosFloatThisFrame.x, box.minPos.y - this.camPosFloatThisFrame.y, box.minPos.z - this.camPosFloatThisFrame.z);
        boxTransform.multiply(Mat4f.createScaleMatrix(box.maxPos.x - box.minPos.x, box.maxPos.y - box.minPos.y, box.maxPos.z - box.minPos.z));
        Mat4f t = this.transformationMatrixThisFrame.copy();
        t.multiply(boxTransform);
        this.basicShader.setUniform(this.basicShader.getUniformLocation("uTransform"), t);
        this.basicShader.setUniform(this.basicShader.getUniformLocation("uColor"), box.color);
        GL32.glDrawElements((int)1, (int)BOX_OUTLINE_INDICES.length, (int)5125, (long)0L);
    }

    private static class RendererLists {
        public final LinkedList<WeakReference<IDebugRenderable>> generalRenderableList = new LinkedList();
        private final HashMap<ConfigEntry<Boolean>, LinkedList<WeakReference<IDebugRenderable>>> renderableListByConfig = new HashMap();

        private RendererLists() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addRenderable(IDebugRenderable renderable, @Nullable ConfigEntry<Boolean> config) {
            RendererLists rendererLists = this;
            synchronized (rendererLists) {
                if (config != null) {
                    if (!this.renderableListByConfig.containsKey(config)) {
                        this.renderableListByConfig.put(config, new LinkedList());
                    }
                    LinkedList<WeakReference<IDebugRenderable>> renderableList = this.renderableListByConfig.get(config);
                    renderableList.add(new WeakReference<IDebugRenderable>(renderable));
                } else {
                    this.generalRenderableList.add(new WeakReference<IDebugRenderable>(renderable));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeRenderable(IDebugRenderable renderable, @Nullable ConfigEntry<Boolean> config) {
            RendererLists rendererLists = this;
            synchronized (rendererLists) {
                if (config != null) {
                    if (this.renderableListByConfig.containsKey(config)) {
                        LinkedList<WeakReference<IDebugRenderable>> renderableList = this.renderableListByConfig.get(config);
                        this.removeRenderableFromInternalList(renderableList, renderable);
                    }
                } else {
                    this.removeRenderableFromInternalList(this.generalRenderableList, renderable);
                }
            }
        }

        private void removeRenderableFromInternalList(LinkedList<WeakReference<IDebugRenderable>> rendererList, IDebugRenderable renderable) {
            Iterator iterator = rendererList.iterator();
            while (iterator.hasNext()) {
                WeakReference renderableRef = (WeakReference)iterator.next();
                if (renderableRef.get() == null) {
                    iterator.remove();
                    continue;
                }
                if (renderableRef.get() != renderable) continue;
                iterator.remove();
                return;
            }
        }

        public void clearRenderables() {
            for (ConfigEntry<Boolean> config : this.renderableListByConfig.keySet()) {
                LinkedList<WeakReference<IDebugRenderable>> renderableList = this.renderableListByConfig.get(config);
                if (!config.get().booleanValue() || renderableList == null) continue;
                renderableList.clear();
            }
        }

        public void render(DebugRenderer debugRenderer) {
            this.renderList(debugRenderer, this.generalRenderableList);
            for (ConfigEntry<Boolean> config : this.renderableListByConfig.keySet()) {
                LinkedList<WeakReference<IDebugRenderable>> renderableList = this.renderableListByConfig.get(config);
                if (!config.get().booleanValue() || renderableList == null || renderableList.size() == 0) continue;
                this.renderList(debugRenderer, renderableList);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void renderList(DebugRenderer debugRenderer, LinkedList<WeakReference<IDebugRenderable>> rendererList) {
            RendererLists rendererLists = this;
            synchronized (rendererLists) {
                try {
                    Iterator iterator = rendererList.iterator();
                    while (iterator.hasNext()) {
                        WeakReference ref = (WeakReference)iterator.next();
                        IDebugRenderable renderable = (IDebugRenderable)ref.get();
                        if (renderable == null) {
                            iterator.remove();
                            continue;
                        }
                        renderable.debugRender(debugRenderer);
                    }
                }
                catch (Exception e) {
                    SPAM_LOGGER.error("Unexpected Debug renderer error, Error: " + e.getMessage(), e);
                }
            }
        }
    }

    public static final class BoxParticle
    implements Comparable<BoxParticle> {
        public Box box;
        public long startTime;
        public long duration;
        public float yChange;

        public BoxParticle(Box box, long startTime, long duration, float yChange) {
            this.box = box;
            this.startTime = startTime;
            this.duration = duration;
            this.yChange = yChange;
        }

        public BoxParticle(Box box, long nanoSecondDuratoin, float yChange) {
            this(box, System.nanoTime(), nanoSecondDuratoin, yChange);
        }

        public BoxParticle(Box box, double secondDuration, float yChange) {
            this(box, System.nanoTime(), (long)(secondDuration * 1.0E9), yChange);
        }

        @Override
        public int compareTo(@NotNull BoxParticle particle) {
            return Long.compare(this.startTime + this.duration, particle.startTime + particle.duration);
        }

        public Box getBox() {
            long now = System.nanoTime();
            float percent = (float)(now - this.startTime) / (float)this.duration;
            percent = (float)Math.pow(percent, 4.0);
            float yDiff = this.yChange * percent;
            return new Box(new Vec3f(this.box.minPos.x, this.box.minPos.y + yDiff, this.box.minPos.z), new Vec3f(this.box.maxPos.x, this.box.maxPos.y + yDiff, this.box.maxPos.z), this.box.color);
        }

        public boolean isDead(long time) {
            return time - this.startTime > this.duration;
        }
    }

    public static final class Box {
        public Vec3f minPos;
        public Vec3f maxPos;
        public Color color;

        public Box(Vec3f minPos, Vec3f maxPos, Color color) {
            this.minPos = minPos;
            this.maxPos = maxPos;
            this.color = color;
        }

        public Box(Vec3f minPos, Vec3f maxPos, Color color, Vec3f margin) {
            this.minPos = minPos;
            this.minPos.add(margin);
            this.maxPos = maxPos;
            this.maxPos.subtract(margin);
            this.color = color;
        }

        public Box(DhLodPos pos, float minY, float maxY, float marginPercent, Color color) {
            DhBlockPos2D blockMin = pos.getCornerBlockPos();
            DhBlockPos2D blockMax = blockMin.add(pos.getBlockWidth(), pos.getBlockWidth());
            float edge = (float)pos.getBlockWidth() * marginPercent;
            Vec3f a = new Vec3f((float)blockMin.x + edge, minY, (float)blockMin.z + edge);
            Vec3f b = new Vec3f((float)blockMax.x - edge, maxY, (float)blockMax.z - edge);
            this.minPos = a;
            this.maxPos = b;
            this.color = color;
        }

        public Box(DhLodPos pos, float y, float yDiff, Object hash, float marginPercent, Color color) {
            float hashY = (float)hash.hashCode() / 2.1474836E9f * yDiff;
            DhBlockPos2D blockMin = pos.getCornerBlockPos();
            DhBlockPos2D blockMax = blockMin.add(pos.getBlockWidth(), pos.getBlockWidth());
            float edge = (float)pos.getBlockWidth() * marginPercent;
            Vec3f a = new Vec3f((float)blockMin.x + edge, hashY, (float)blockMin.z + edge);
            Vec3f b = new Vec3f((float)blockMax.x - edge, hashY, (float)blockMax.z - edge);
            this.minPos = a;
            this.maxPos = b;
            this.color = color;
        }

        public Box(long pos, float minY, float maxY, float marginPercent, Color color) {
            this(DhSectionPos.getSectionBBoxPos(pos), minY, maxY, marginPercent, color);
        }

        public Box(long pos, float y, float yDiff, Object hash, float marginPercent, Color color) {
            this(DhSectionPos.getSectionBBoxPos(pos), y, yDiff, hash, marginPercent, color);
        }
    }

    public static final class BoxWithLife
    implements IDebugRenderable,
    Closeable {
        public Box box;
        public BoxParticle particaleOnClose;

        public BoxWithLife(Box box, long ns, float yChange, Color deathColor) {
            this.box = box;
            this.particaleOnClose = new BoxParticle(new Box(box.minPos, box.maxPos, deathColor), -1L, ns, yChange);
            DebugRenderer.register(this, null);
        }

        public BoxWithLife(Box box, long ns, float yChange) {
            this(box, ns, yChange, box.color);
        }

        public BoxWithLife(Box box, double s, float yChange, Color deathColor) {
            this.box = box;
            this.particaleOnClose = new BoxParticle(new Box(box.minPos, box.maxPos, deathColor), s, yChange);
        }

        public BoxWithLife(Box box, double s, float yChange) {
            this(box, s, yChange, box.color);
        }

        @Override
        public void debugRender(DebugRenderer renderer) {
            renderer.renderBox(this.box);
        }

        @Override
        public void close() {
            DebugRenderer.makeParticle(new BoxParticle(this.particaleOnClose.getBox(), System.nanoTime(), this.particaleOnClose.duration, this.particaleOnClose.yChange));
            DebugRenderer.unregister(this, null);
        }
    }
}

