/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.network.messages.requests;

import com.google.common.base.MoreObjects;
import com.seibel.distanthorizons.core.network.exceptions.InvalidLevelException;
import com.seibel.distanthorizons.core.network.exceptions.InvalidSectionPosException;
import com.seibel.distanthorizons.core.network.exceptions.RateLimitedException;
import com.seibel.distanthorizons.core.network.exceptions.RequestRejectedException;
import com.seibel.distanthorizons.core.network.messages.TrackableMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;

public class ExceptionMessage
extends TrackableMessage {
    private static final List<Class<? extends Exception>> exceptionMap = new ArrayList<Class<? extends Exception>>(){
        {
            this.add(RateLimitedException.class);
            this.add(InvalidLevelException.class);
            this.add(InvalidSectionPosException.class);
            this.add(RequestRejectedException.class);
        }
    };
    public Exception exception;

    public ExceptionMessage() {
    }

    public ExceptionMessage(Exception exception) {
        this.exception = exception;
    }

    @Override
    protected void encode0(ByteBuf out) {
        out.writeInt(exceptionMap.indexOf(this.exception.getClass()));
        this.writeString(this.exception.getMessage(), out);
    }

    @Override
    protected void decode0(ByteBuf in) throws Exception {
        int id = in.readInt();
        String message = this.readString(in);
        this.exception = exceptionMap.get(id).getDeclaredConstructor(String.class).newInstance(message);
    }

    @Override
    public MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("exception", (Object)this.exception);
    }
}

