/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.network.messages;

import com.google.common.base.MoreObjects;
import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.network.messages.NetworkMessage;
import com.seibel.distanthorizons.core.network.messages.requests.ExceptionMessage;
import com.seibel.distanthorizons.core.network.session.Session;
import com.seibel.distanthorizons.core.world.EWorldEnvironment;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class TrackableMessage
extends NetworkMessage {
    private static final AtomicInteger lastId = new AtomicInteger();
    public long futureId = lastId.getAndIncrement() | (Objects.requireNonNull(SharedApi.getEnvironment()) == EWorldEnvironment.Server_Only ? 1 : 0) << 31;

    @Override
    public void setSession(Session session) {
        super.setSession(session);
        this.futureId |= (long)session.id << 32;
    }

    public void sendResponse(TrackableMessage responseMessage) {
        responseMessage.futureId = this.futureId;
        this.getSession().sendMessage(responseMessage);
    }

    public void sendResponse(Exception e) {
        this.sendResponse(new ExceptionMessage(e));
    }

    @Override
    public final void encode(ByteBuf out) {
        try {
            out.writeInt((int)this.futureId);
            this.encode0(out);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final void decode(ByteBuf in) {
        try {
            this.futureId = in.readInt();
            this.decode0(in);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract void encode0(ByteBuf var1) throws Exception;

    protected abstract void decode0(ByteBuf var1) throws Exception;

    @Override
    public MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("futureId", this.futureId);
    }
}

