/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.network.messages;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.seibel.distanthorizons.core.network.messages.NetworkMessage;
import com.seibel.distanthorizons.core.network.messages.base.CloseReasonMessage;
import com.seibel.distanthorizons.core.network.messages.base.CodecCrashMessage;
import com.seibel.distanthorizons.core.network.messages.base.CurrentLevelKeyMessage;
import com.seibel.distanthorizons.core.network.messages.base.SessionConfigMessage;
import com.seibel.distanthorizons.core.network.messages.fullData.FullDataChunkMessage;
import com.seibel.distanthorizons.core.network.messages.fullData.FullDataPartialUpdateMessage;
import com.seibel.distanthorizons.core.network.messages.fullData.FullDataSourceRequestMessage;
import com.seibel.distanthorizons.core.network.messages.fullData.FullDataSourceResponseMessage;
import com.seibel.distanthorizons.core.network.messages.requests.CancelMessage;
import com.seibel.distanthorizons.core.network.messages.requests.ExceptionMessage;
import com.seibel.distanthorizons.coreapi.ModInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class MessageRegistry {
    public static final boolean DEBUG_ENABLE_CODEC_CRASH_MESSAGE = ModInfo.IS_DEV_BUILD;
    public static final MessageRegistry INSTANCE = new MessageRegistry();
    private final Map<Integer, Supplier<? extends NetworkMessage>> idToSupplier = new HashMap<Integer, Supplier<? extends NetworkMessage>>();
    private final BiMap<Class<? extends NetworkMessage>, Integer> classToId = HashBiMap.create();

    private MessageRegistry() {
        this.registerMessage(CloseReasonMessage.class, CloseReasonMessage::new);
        this.registerMessage(CurrentLevelKeyMessage.class, CurrentLevelKeyMessage::new);
        this.registerMessage(SessionConfigMessage.class, SessionConfigMessage::new);
        this.registerMessage(CancelMessage.class, CancelMessage::new);
        this.registerMessage(ExceptionMessage.class, ExceptionMessage::new);
        this.registerMessage(FullDataSourceRequestMessage.class, FullDataSourceRequestMessage::new);
        this.registerMessage(FullDataSourceResponseMessage.class, FullDataSourceResponseMessage::new);
        this.registerMessage(FullDataPartialUpdateMessage.class, FullDataPartialUpdateMessage::new);
        this.registerMessage(FullDataChunkMessage.class, FullDataChunkMessage::new);
        if (DEBUG_ENABLE_CODEC_CRASH_MESSAGE) {
            this.registerMessage(CodecCrashMessage.class, CodecCrashMessage::new);
        }
    }

    public <T extends NetworkMessage> void registerMessage(Class<T> clazz, Supplier<T> supplier) {
        int id = this.idToSupplier.size() + 1;
        this.idToSupplier.put(id, supplier);
        this.classToId.put(clazz, (Object)id);
    }

    public NetworkMessage createMessage(int messageId) throws IllegalArgumentException {
        try {
            return this.idToSupplier.get(messageId).get();
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Invalid message ID: " + messageId);
        }
    }

    public int getMessageId(NetworkMessage message) {
        return this.getMessageId(message.getClass());
    }

    public int getMessageId(Class<? extends NetworkMessage> messageClass) {
        try {
            return (Integer)this.classToId.get(messageClass);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Message does not have ID assigned to it: " + messageClass.getSimpleName());
        }
    }
}

