/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.network.event;

import com.google.common.cache.CacheBuilder;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import com.seibel.distanthorizons.core.network.event.internal.InternalEvent;
import com.seibel.distanthorizons.core.network.messages.MessageRegistry;
import com.seibel.distanthorizons.core.network.messages.NetworkMessage;
import com.seibel.distanthorizons.core.network.messages.TrackableMessage;
import com.seibel.distanthorizons.core.network.messages.requests.CancelMessage;
import com.seibel.distanthorizons.core.network.messages.requests.ExceptionMessage;
import com.seibel.distanthorizons.core.network.session.SessionClosedException;
import com.seibel.distanthorizons.coreapi.ModInfo;
import java.io.InvalidClassException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;

public abstract class NetworkEventSource {
    private static final ConfigBasedLogger LOGGER = new ConfigBasedLogger(LogManager.getLogger(), () -> Config.Client.Advanced.Logging.logNetworkEvent.get());
    protected final ConcurrentMap<Class<? extends NetworkMessage>, ConcurrentMap<NetworkEventSource, Set<Consumer<NetworkMessage>>>> handlers = new ConcurrentHashMap<Class<? extends NetworkMessage>, ConcurrentMap<NetworkEventSource, Set<Consumer<NetworkMessage>>>>();
    private final ConcurrentMap<Long, FutureResponseData> pendingFutures = new ConcurrentHashMap<Long, FutureResponseData>();
    private final Set<Long> cancelledFutures = Collections.newSetFromMap(CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build().asMap());

    protected void handleMessage(NetworkMessage message) {
        boolean handled = false;
        ConcurrentMap handlersByEventSource = (ConcurrentMap)this.handlers.get(message.getClass());
        if (handlersByEventSource != null) {
            for (Set handlerSet : handlersByEventSource.values()) {
                for (Consumer handler : handlerSet) {
                    handled = true;
                    handler.accept(message);
                }
            }
        }
        if (message instanceof TrackableMessage) {
            TrackableMessage trackableMessage = (TrackableMessage)message;
            FutureResponseData responseData = (FutureResponseData)this.pendingFutures.get(trackableMessage.futureId);
            if (responseData != null) {
                handled = true;
                if (message instanceof ExceptionMessage) {
                    responseData.future.completeExceptionally(((ExceptionMessage)message).exception);
                } else if (message.getClass() != responseData.responseClass) {
                    responseData.future.completeExceptionally(new InvalidClassException("Response with invalid type: expected " + responseData.responseClass.getSimpleName() + ", got:" + message));
                } else {
                    responseData.future.complete(trackableMessage);
                }
            } else if (this.cancelledFutures.remove(trackableMessage.futureId)) {
                handled = true;
            }
        }
        if (!handled && ModInfo.IS_DEV_BUILD) {
            LOGGER.warn("Unhandled message: {}", message);
        }
    }

    public abstract <T extends NetworkMessage> void registerHandler(Class<T> var1, Consumer<T> var2);

    protected final <T extends NetworkMessage> void registerHandler(NetworkEventSource instance, Class<T> handlerClass, Consumer<T> handlerImplementation) {
        if (!InternalEvent.class.isAssignableFrom(handlerClass)) {
            MessageRegistry.INSTANCE.getMessageId(handlerClass);
        }
        this.handlers.computeIfAbsent(handlerClass, missingHandlerClass -> new ConcurrentHashMap()).computeIfAbsent(instance, _instance -> ConcurrentHashMap.newKeySet()).add(handlerImplementation);
    }

    protected void removeAllHandlers(NetworkEventSource childInstance) {
        for (ConcurrentMap handlerMap : this.handlers.values()) {
            handlerMap.remove(childInstance);
        }
    }

    protected <TResponse extends TrackableMessage> CompletableFuture<TResponse> createRequest(TrackableMessage msg, Class<TResponse> responseClass) {
        CompletableFuture responseFuture = new CompletableFuture();
        responseFuture.whenComplete((response, throwable) -> {
            if (throwable instanceof CancellationException) {
                this.cancelledFutures.add(msg.futureId);
                msg.sendResponse(new CancelMessage());
            }
            if (!(throwable instanceof SessionClosedException)) {
                this.pendingFutures.remove(msg.futureId);
            }
        });
        this.pendingFutures.put(msg.futureId, new FutureResponseData(responseClass, responseFuture));
        return responseFuture;
    }

    protected final void completeAllFuturesExceptionally(Throwable cause) {
        for (FutureResponseData responseData : this.pendingFutures.values()) {
            responseData.future.completeExceptionally(cause);
        }
    }

    public void close() {
        this.handlers.clear();
        this.completeAllFuturesExceptionally(new SessionClosedException(this.getClass().getSimpleName() + " is closed."));
    }

    private static class FutureResponseData {
        public final Class<? extends TrackableMessage> responseClass;
        public final CompletableFuture<TrackableMessage> future;

        private <T extends TrackableMessage> FutureResponseData(Class<T> responseClass, CompletableFuture<T> future) {
            this.responseClass = responseClass;
            this.future = future;
        }
    }
}

