/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.multiplayer.config;

import com.google.common.base.MoreObjects;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.listeners.ConfigChangeListener;
import com.seibel.distanthorizons.core.config.types.ConfigEntry;
import com.seibel.distanthorizons.core.network.INetworkObject;
import io.netty.buffer.ByteBuf;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SessionConfig
implements INetworkObject {
    private static final LinkedHashMap<String, Entry> CONFIG_ENTRIES = new LinkedHashMap();
    private final LinkedHashMap<String, Object> values = new LinkedHashMap();
    public SessionConfig constrainingConfig;

    private static <T> void registerConfigEntry(ConfigEntry<T> configEntry, BiFunction<T, T, T> valueConstrainer) {
        CONFIG_ENTRIES.put(Objects.requireNonNull(configEntry.getServersideShortName()), new Entry(configEntry, valueConstrainer));
    }

    public int getRenderDistanceRadius() {
        return this.getValue(Config.Client.Advanced.Graphics.Quality.lodChunkRenderDistanceRadius);
    }

    public boolean isDistantGenerationEnabled() {
        return this.getValue(Config.Client.Advanced.WorldGenerator.enableDistantGeneration);
    }

    public int getGenerationRequestRateLimit() {
        return this.getValue(Config.Client.Advanced.Multiplayer.ServerNetworking.generationRequestRateLimit);
    }

    public boolean isRealTimeUpdatesEnabled() {
        return this.getValue(Config.Client.Advanced.Multiplayer.ServerNetworking.enableRealTimeUpdates);
    }

    public boolean getSynchronizeOnLogin() {
        return this.getValue(Config.Client.Advanced.Multiplayer.ServerNetworking.synchronizeOnLogin);
    }

    public int getSyncOnLoginRateLimit() {
        return this.getValue(Config.Client.Advanced.Multiplayer.ServerNetworking.syncOnLoginRateLimit);
    }

    private <T> T getValue(String name) {
        Entry entry = CONFIG_ENTRIES.get(name);
        Object value = this.values.get(name);
        if (value == null) {
            value = entry.supplier.get();
        }
        return (T)(this.constrainingConfig != null ? entry.valueConstrainer.apply(value, this.constrainingConfig.getValue(name)) : value);
    }

    private <T> T getValue(ConfigEntry<T> configEntry) {
        return this.getValue(configEntry.getServersideShortName());
    }

    private Map<String, ?> getValues() {
        return CONFIG_ENTRIES.keySet().stream().collect(Collectors.toMap(Function.identity(), this::getValue, (x, y) -> x, LinkedHashMap::new));
    }

    @Override
    public void encode(ByteBuf out) {
        this.writeFixedLengthCollection(out, this.getValues().values());
    }

    @Override
    public void decode(ByteBuf in) {
        for (String key : CONFIG_ENTRIES.keySet()) {
            Object currentValue = this.getValue(key);
            Object newValue = INetworkObject.Codec.getCodec(currentValue.getClass()).decode.apply(currentValue, in);
            this.values.put(key, newValue);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("values", this.getValues()).toString();
    }

    static {
        SessionConfig.registerConfigEntry(Config.Client.Advanced.Graphics.Quality.lodChunkRenderDistanceRadius, Math::min);
        SessionConfig.registerConfigEntry(Config.Client.Advanced.WorldGenerator.enableDistantGeneration, (x, y) -> x != false && y != false);
        SessionConfig.registerConfigEntry(Config.Client.Advanced.Multiplayer.ServerNetworking.generationRequestRateLimit, Math::min);
        SessionConfig.registerConfigEntry(Config.Client.Advanced.Multiplayer.ServerNetworking.enableRealTimeUpdates, (x, y) -> x != false && y != false);
        SessionConfig.registerConfigEntry(Config.Client.Advanced.Multiplayer.ServerNetworking.synchronizeOnLogin, (x, y) -> x != false && y != false);
        SessionConfig.registerConfigEntry(Config.Client.Advanced.Multiplayer.ServerNetworking.syncOnLoginRateLimit, Math::min);
    }

    private static class Entry {
        public final ConfigEntry<Object> supplier;
        public final BiFunction<Object, Object, Object> valueConstrainer;

        private <T> Entry(ConfigEntry<T> supplier, BiFunction<T, T, T> valueConstrainer) {
            this.supplier = supplier;
            this.valueConstrainer = valueConstrainer;
        }
    }

    public static class ChangeListener
    implements Closeable {
        private final ArrayList<ConfigChangeListener<?>> changeListeners = new ArrayList(SessionConfig.access$100().size());

        public ChangeListener(Runnable runnable) {
            for (Entry entry : CONFIG_ENTRIES.values()) {
                this.changeListeners.add(new ConfigChangeListener<Object>(entry.supplier, ignored -> runnable.run()));
            }
        }

        @Override
        public void close() {
            for (ConfigChangeListener<?> changeListener : this.changeListeners) {
                changeListener.close();
            }
            this.changeListeners.clear();
        }
    }
}

