/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.multiplayer.client;

import com.google.common.cache.CacheBuilder;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import com.seibel.distanthorizons.core.multiplayer.config.SessionConfig;
import com.seibel.distanthorizons.core.network.INetworkObject;
import com.seibel.distanthorizons.core.network.event.internal.CloseEvent;
import com.seibel.distanthorizons.core.network.event.internal.IncompatibleMessageEvent;
import com.seibel.distanthorizons.core.network.messages.base.CurrentLevelKeyMessage;
import com.seibel.distanthorizons.core.network.messages.base.SessionConfigMessage;
import com.seibel.distanthorizons.core.network.messages.fullData.FullDataChunkMessage;
import com.seibel.distanthorizons.core.network.messages.fullData.FullDataPartialUpdateMessage;
import com.seibel.distanthorizons.core.network.messages.fullData.FullDataPayload;
import com.seibel.distanthorizons.core.network.session.Session;
import com.seibel.distanthorizons.core.sql.dto.FullDataSourceV2DTO;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import java.io.Closeable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.Nullable;

public class ClientNetworkState
implements Closeable {
    protected static final ConfigBasedLogger LOGGER = new ConfigBasedLogger(LogManager.getLogger(), () -> Config.Client.Advanced.Logging.logNetworkEvent.get());
    private final Session session = new Session(null);
    public SessionConfig config = new SessionConfig();
    private volatile boolean configReceived = false;
    private final SessionConfig.ChangeListener configChangeListener = new SessionConfig.ChangeListener(this::sendConfigMessage);
    private EServerSupportStatus serverSupportStatus = EServerSupportStatus.NONE;
    @Nullable
    private Integer closestProtocolVersion;
    private final ConcurrentMap<Integer, CompositeByteBuf> fullDataBuffers = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build().asMap();

    public Session getSession() {
        return this.session;
    }

    public boolean isReady() {
        return this.configReceived;
    }

    public ClientNetworkState() {
        this.session.registerHandler(IncompatibleMessageEvent.class, event -> {
            if (this.closestProtocolVersion == null || Math.abs(event.protocolVersion - 3) < this.closestProtocolVersion) {
                this.closestProtocolVersion = event.protocolVersion;
            }
        });
        this.session.registerHandler(CurrentLevelKeyMessage.class, msg -> {
            if (this.serverSupportStatus == EServerSupportStatus.NONE) {
                this.serverSupportStatus = EServerSupportStatus.LEVELS_ONLY;
            }
        });
        this.session.registerHandler(SessionConfigMessage.class, msg -> {
            this.serverSupportStatus = EServerSupportStatus.FULL;
            LOGGER.info("Connection config has been changed: {}", msg.config);
            this.config = msg.config;
            this.configReceived = true;
        });
        this.session.registerHandler(CloseEvent.class, msg -> {
            this.configReceived = false;
        });
        this.session.registerHandler(FullDataChunkMessage.class, msg -> {
            CompositeByteBuf composite;
            if (msg.isFirst && (composite = (CompositeByteBuf)this.fullDataBuffers.remove(msg.bufferId)) != null) {
                composite.release();
                LOGGER.debug("Released full data buffer {}: {}", msg.bufferId, composite);
            }
            composite = this.fullDataBuffers.computeIfAbsent(msg.bufferId, bufferId -> ByteBufAllocator.DEFAULT.compositeBuffer());
            composite.addComponent(true, msg.buffer);
            LOGGER.debug("Full data buffer {}: {}", msg.bufferId, composite);
        });
        this.session.registerHandler(FullDataPartialUpdateMessage.class, msg -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FullDataSourceV2DTO decodeDataSourceAndReleaseBuffer(FullDataPayload msg) {
        CompositeByteBuf composite = (CompositeByteBuf)this.fullDataBuffers.remove(msg.dtoBufferId);
        Objects.requireNonNull(composite);
        try {
            FullDataSourceV2DTO fullDataSourceV2DTO = INetworkObject.decodeToInstance(new FullDataSourceV2DTO(), (ByteBuf)composite);
            return fullDataSourceV2DTO;
        }
        finally {
            composite.release();
        }
    }

    public void sendConfigMessage() {
        this.configReceived = false;
        this.getSession().sendMessage(new SessionConfigMessage(new SessionConfig()));
    }

    public void addDebugMenuStringsToList(List<String> messageList) {
        if (this.session.isClosed()) {
            messageList.add("Session closed: " + this.session.getCloseReason().getMessage());
            return;
        }
        if (this.serverSupportStatus == EServerSupportStatus.NONE && this.closestProtocolVersion != null) {
            messageList.add("Incompatible protocol version: " + this.closestProtocolVersion + ", required: " + 3);
            return;
        }
        messageList.add(this.serverSupportStatus.message);
    }

    @Override
    public void close() {
        this.configChangeListener.close();
        this.session.close();
    }

    private static enum EServerSupportStatus {
        NONE("Server does not support DH"),
        LEVELS_ONLY("Server supports shared level keys"),
        FULL("Server has full DH support");

        public final String message;

        private EServerSupportStatus(String message) {
            this.message = message;
        }
    }
}

