/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.level;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.file.fullDatafile.FullDataSourceProviderV2;
import com.seibel.distanthorizons.core.file.structure.AbstractSaveStructure;
import com.seibel.distanthorizons.core.level.AbstractDhLevel;
import com.seibel.distanthorizons.core.level.IDhServerLevel;
import com.seibel.distanthorizons.core.level.ServerLevelModule;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.multiplayer.server.RemotePlayerConnectionHandler;
import com.seibel.distanthorizons.core.multiplayer.server.ServerPlayerState;
import com.seibel.distanthorizons.core.network.exceptions.InvalidLevelException;
import com.seibel.distanthorizons.core.network.exceptions.RequestRejectedException;
import com.seibel.distanthorizons.core.network.messages.ILevelRelatedMessage;
import com.seibel.distanthorizons.core.network.messages.NetworkMessage;
import com.seibel.distanthorizons.core.network.messages.TrackableMessage;
import com.seibel.distanthorizons.core.network.messages.fullData.FullDataPartialUpdateMessage;
import com.seibel.distanthorizons.core.network.messages.fullData.FullDataPayload;
import com.seibel.distanthorizons.core.network.messages.fullData.FullDataSourceRequestMessage;
import com.seibel.distanthorizons.core.network.messages.fullData.FullDataSourceResponseMessage;
import com.seibel.distanthorizons.core.network.messages.requests.CancelMessage;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.render.RenderBufferHandler;
import com.seibel.distanthorizons.core.render.renderer.generic.GenericObjectRenderer;
import com.seibel.distanthorizons.core.sql.repo.FullDataSourceV2Repo;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.math.Vec3d;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.IServerPlayerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DhServerLevel
extends AbstractDhLevel
implements IDhServerLevel {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final ConfigBasedLogger NETWORK_LOGGER = new ConfigBasedLogger(LogManager.getLogger(), () -> Config.Client.Advanced.Logging.logNetworkEvent.get());
    public static final int FULL_DATA_CHUNK_SIZE = 1048000;
    public final ServerLevelModule serverside;
    private final IServerLevelWrapper serverLevelWrapper;
    private final RemotePlayerConnectionHandler remotePlayerConnectionHandler;
    private final ConcurrentLinkedQueue<IServerPlayerWrapper> worldGenPlayerCenteringQueue = new ConcurrentLinkedQueue();
    private final ConcurrentMap<Long, DataSourceRequestGroup> requestGroupsByPos = new ConcurrentHashMap<Long, DataSourceRequestGroup>();
    private final ConcurrentMap<Long, DataSourceRequestGroup> requestGroupsByFutureId = new ConcurrentHashMap<Long, DataSourceRequestGroup>();

    public DhServerLevel(AbstractSaveStructure saveStructure, IServerLevelWrapper serverLevelWrapper, RemotePlayerConnectionHandler remotePlayerConnectionHandler) {
        if (saveStructure.getFullDataFolder(serverLevelWrapper).mkdirs()) {
            LOGGER.warn("unable to create data folder.");
        }
        this.serverLevelWrapper = serverLevelWrapper;
        this.serverside = new ServerLevelModule(this, saveStructure);
        this.createAndSetSupportingRepos(((FullDataSourceV2Repo)this.serverside.fullDataFileHandler.repo).databaseFile);
        this.runRepoReliantSetup();
        LOGGER.info("Started DHLevel for {} with saves at {}", (Object)serverLevelWrapper, (Object)saveStructure);
        this.remotePlayerConnectionHandler = remotePlayerConnectionHandler;
    }

    public void registerNetworkHandlers(ServerPlayerState serverPlayerState) {
        serverPlayerState.session.registerHandler(FullDataSourceRequestMessage.class, this.currentLevelOnly(msg -> {
            ServerPlayerState.RateLimiterSet rateLimiterSet = serverPlayerState.getRateLimiterSet(this);
            if (msg.clientTimestamp == null) {
                DataSourceRequestGroup requestGroup;
                if (!serverPlayerState.config.isDistantGenerationEnabled()) {
                    msg.sendResponse(new RequestRejectedException("Operation is disabled from config."));
                    return;
                }
                if (!rateLimiterSet.generationRequestRateLimiter.tryAcquire((FullDataSourceRequestMessage)msg)) {
                    return;
                }
                while (true) {
                    requestGroup = this.requestGroupsByPos.computeIfAbsent(msg.sectionPos, pos -> {
                        DataSourceRequestGroup newGroup = new DataSourceRequestGroup();
                        this.tryFulfillDataSourceRequestGroup(newGroup, (long)pos);
                        NETWORK_LOGGER.debug("[{}] Created request group for pos {}", this.serverLevelWrapper.getDimensionName(), pos);
                        return newGroup;
                    });
                    if (requestGroup.requestAddSemaphore.tryAcquire()) break;
                    Thread.yield();
                }
                this.requestGroupsByFutureId.put(msg.futureId, requestGroup);
                requestGroup.requestMessages.put(msg.futureId, (FullDataSourceRequestMessage)msg);
                requestGroup.requestAddSemaphore.release();
            } else {
                if (!serverPlayerState.config.getSynchronizeOnLogin()) {
                    msg.sendResponse(new RequestRejectedException("Operation is disabled from config."));
                    return;
                }
                if (!rateLimiterSet.syncOnLoginRateLimiter.tryAcquire((FullDataSourceRequestMessage)msg)) {
                    return;
                }
                Long serverTimestamp = this.serverside.fullDataFileHandler.getTimestampForPos(msg.sectionPos);
                if (serverTimestamp == null || serverTimestamp <= msg.clientTimestamp) {
                    rateLimiterSet.syncOnLoginRateLimiter.release();
                    msg.sendResponse(new FullDataSourceResponseMessage(null));
                    return;
                }
                ThreadPoolExecutor executor = ThreadPoolUtil.getNetworkCompressionExecutor();
                if (executor == null) {
                    LOGGER.warn("Unable to send FullDataSourceResponseMessage - getNetworkCompressionExecutor() is null");
                    return;
                }
                this.serverside.fullDataFileHandler.getAsync(msg.sectionPos).thenAcceptAsync(fullDataSource -> {
                    rateLimiterSet.syncOnLoginRateLimiter.release();
                    FullDataPayload payload = new FullDataPayload((FullDataSourceV2)fullDataSource);
                    payload.acceptInChunkMessages(1048000, msg.getSession()::sendMessage);
                    msg.sendResponse(new FullDataSourceResponseMessage(payload));
                }, (Executor)executor);
            }
        }));
        serverPlayerState.session.registerHandler(CancelMessage.class, msg -> {
            DataSourceRequestGroup requestGroup = (DataSourceRequestGroup)this.requestGroupsByFutureId.remove(msg.futureId);
            if (requestGroup == null) {
                return;
            }
            if (requestGroup.requestRemoveSemaphore.tryAcquire()) {
                requestGroup.requestAddSemaphore.acquireUninterruptibly(Short.MAX_VALUE);
                requestGroup.requestRemoveSemaphore.release();
                serverPlayerState.getRateLimiterSet((DhServerLevel)this).generationRequestRateLimiter.release();
                FullDataSourceRequestMessage requestMessage = (FullDataSourceRequestMessage)requestGroup.requestMessages.remove(msg.futureId);
                if (requestGroup.requestMessages.isEmpty()) {
                    NETWORK_LOGGER.debug("[{}] Cancelled request group {}", this.serverLevelWrapper.getDimensionName(), requestMessage.sectionPos);
                    this.requestGroupsByPos.remove(requestMessage.sectionPos);
                    this.serverside.fullDataFileHandler.removeRetrievalRequestIf(pos -> pos == requestMessage.sectionPos);
                } else {
                    requestGroup.requestAddSemaphore.release(Short.MAX_VALUE);
                }
            }
        });
    }

    public <T extends NetworkMessage> Consumer<T> currentLevelOnly(Consumer<T> next) {
        return msg -> {
            LodUtil.assertTrue(msg instanceof ILevelRelatedMessage, MessageFormat.format("Received message does not implement {0}: {1}", ILevelRelatedMessage.class.getSimpleName(), msg.getClass().getSimpleName()));
            if (!((ILevelRelatedMessage)((Object)msg)).isSameLevelAs(this.getServerLevelWrapper())) {
                return;
            }
            assert (msg.getSession().serverPlayer != null);
            if (msg.getSession().serverPlayer.getLevel() != this.getLevelWrapper()) {
                if (msg instanceof TrackableMessage) {
                    ((TrackableMessage)msg).sendResponse(new InvalidLevelException(MessageFormat.format("Generation not allowed. Requested dimension: {0}, player dimension: {1}, handler dimension: {2}", ((ILevelRelatedMessage)((Object)msg)).getLevelName(), msg.getSession().serverPlayer.getLevel().getDimensionName(), this.getLevelWrapper().getDimensionName())));
                }
                return;
            }
            next.accept(msg);
        };
    }

    public void addPlayer(IServerPlayerWrapper serverPlayer) {
        this.worldGenPlayerCenteringQueue.add(serverPlayer);
    }

    public void removePlayer(IServerPlayerWrapper serverPlayer) {
        this.worldGenPlayerCenteringQueue.remove(serverPlayer);
    }

    @Override
    public void serverTick() {
        for (Map.Entry entry : this.requestGroupsByPos.entrySet()) {
            DataSourceRequestGroup requestGroup = (DataSourceRequestGroup)entry.getValue();
            if (requestGroup.fullDataSource == null) continue;
            NETWORK_LOGGER.debug("[{}] Fulfilled request group {}", this.serverLevelWrapper.getDimensionName(), entry.getKey());
            this.requestGroupsByPos.remove(entry.getKey());
            requestGroup.requestRemoveSemaphore.acquireUninterruptibly(Short.MAX_VALUE);
            requestGroup.requestAddSemaphore.acquireUninterruptibly(Short.MAX_VALUE);
            ThreadPoolExecutor executor = ThreadPoolUtil.getNetworkCompressionExecutor();
            if (executor == null) {
                LOGGER.warn("Unable to send FullDataSourceResponseMessage - getNetworkCompressionExecutor() is null");
                continue;
            }
            CompletableFuture.runAsync(() -> {
                FullDataPayload payload = new FullDataPayload(requestGroup.fullDataSource);
                for (FullDataSourceRequestMessage msg : requestGroup.requestMessages.values()) {
                    this.requestGroupsByFutureId.remove(msg.futureId);
                    ServerPlayerState serverPlayerState = this.remotePlayerConnectionHandler.getConnectedPlayer(msg.serverPlayer());
                    if (serverPlayerState == null) continue;
                    serverPlayerState.getRateLimiterSet((DhServerLevel)this).generationRequestRateLimiter.release();
                    payload.acceptInChunkMessages(1048000, msg.getSession()::sendMessage);
                    msg.sendResponse(new FullDataSourceResponseMessage(payload));
                }
            }, executor);
        }
    }

    @Override
    public CompletableFuture<Void> updateDataSourcesAsync(FullDataSourceV2 data) {
        if (!Config.Client.Advanced.Multiplayer.ServerNetworking.enableRealTimeUpdates.get().booleanValue()) {
            return this.getFullDataProvider().updateDataSourceAsync(data);
        }
        ThreadPoolExecutor executor = ThreadPoolUtil.getNetworkCompressionExecutor();
        if (executor == null) {
            LOGGER.warn("Unable to send FullDataPartialUpdateMessage - getNetworkCompressionExecutor() is null");
            return this.getFullDataProvider().updateDataSourceAsync(data);
        }
        CompletableFuture.runAsync(() -> {
            FullDataPayload payload = new FullDataPayload(data);
            for (ServerPlayerState serverPlayerState : this.remotePlayerConnectionHandler.getConnectedPlayers()) {
                if (serverPlayerState.serverPlayer().getLevel() != this.serverLevelWrapper || !serverPlayerState.config.isRealTimeUpdatesEnabled()) continue;
                Vec3d playerPosition = serverPlayerState.serverPlayer().getPosition();
                int distanceFromPlayer = DhSectionPos.getManhattanBlockDistance(data.getPos(), new DhBlockPos2D((int)playerPosition.x, (int)playerPosition.z)) / 16;
                if (distanceFromPlayer < serverPlayerState.serverPlayer().getViewDistance() || distanceFromPlayer > serverPlayerState.config.getRenderDistanceRadius()) continue;
                payload.acceptInChunkMessages(1048000, serverPlayerState.session::sendMessage);
                serverPlayerState.session.sendMessage(new FullDataPartialUpdateMessage(this.serverLevelWrapper, payload));
            }
        }, executor);
        return this.getFullDataProvider().updateDataSourceAsync(data);
    }

    @Override
    public int getMinY() {
        return this.getLevelWrapper().getMinHeight();
    }

    @Override
    public void close() {
        super.close();
        this.serverside.close();
        LOGGER.info("Closed DHLevel for {}", (Object)this.getLevelWrapper());
    }

    @Override
    public void doWorldGen() {
        boolean shouldDoWorldGen = true;
        boolean isWorldGenRunning = this.serverside.worldGenModule.isWorldGenRunning();
        if (shouldDoWorldGen && !isWorldGenRunning) {
            this.serverside.worldGenModule.startWorldGen(this.serverside.fullDataFileHandler, new ServerLevelModule.WorldGenState(this));
        } else if (!shouldDoWorldGen && isWorldGenRunning) {
            this.serverside.worldGenModule.stopWorldGen(this.serverside.fullDataFileHandler);
        }
        if (this.serverside.worldGenModule.isWorldGenRunning()) {
            IServerPlayerWrapper firstPlayer = this.worldGenPlayerCenteringQueue.peek();
            if (firstPlayer == null) {
                return;
            }
            this.worldGenPlayerCenteringQueue.add(firstPlayer);
            this.worldGenPlayerCenteringQueue.remove(firstPlayer);
            Vec3d position = firstPlayer.getPosition();
            this.serverside.worldGenModule.worldGenTick(new DhBlockPos2D((int)position.x, (int)position.z));
        }
    }

    @Override
    public IServerLevelWrapper getServerLevelWrapper() {
        return this.serverLevelWrapper;
    }

    @Override
    public ILevelWrapper getLevelWrapper() {
        return this.getServerLevelWrapper();
    }

    @Override
    public FullDataSourceProviderV2 getFullDataProvider() {
        return this.serverside.fullDataFileHandler;
    }

    @Override
    public AbstractSaveStructure getSaveStructure() {
        return this.serverside.saveStructure;
    }

    @Override
    public boolean hasSkyLight() {
        return this.serverLevelWrapper.hasSkyLight();
    }

    private void tryFulfillDataSourceRequestGroup(DataSourceRequestGroup requestGroup, long pos) {
        this.serverside.fullDataFileHandler.getAsync(pos).thenAccept(fullDataSource -> {
            if (this.serverside.fullDataFileHandler.isFullyGenerated(fullDataSource.columnGenerationSteps)) {
                requestGroup.fullDataSource = fullDataSource;
            } else {
                this.serverside.fullDataFileHandler.queuePositionForRetrieval(pos);
            }
        });
    }

    @Override
    public void onWorldGenTaskComplete(long pos) {
        DataSourceRequestGroup requestGroup = (DataSourceRequestGroup)this.requestGroupsByPos.get(pos);
        if (requestGroup != null) {
            this.tryFulfillDataSourceRequestGroup(requestGroup, pos);
        }
    }

    @Override
    public GenericObjectRenderer getGenericRenderer() {
        return null;
    }

    @Override
    public RenderBufferHandler getRenderBufferHandler() {
        return null;
    }

    @Override
    public void addDebugMenuStringsToList(List<String> messageList) {
        String dimName = this.serverLevelWrapper.getDimensionName();
        messageList.add("[" + dimName + "]");
    }

    private static class DataSourceRequestGroup {
        public final ConcurrentMap<Long, FullDataSourceRequestMessage> requestMessages = new ConcurrentHashMap<Long, FullDataSourceRequestMessage>();
        @CheckForNull
        public FullDataSourceV2 fullDataSource;
        public final Semaphore requestAddSemaphore = new Semaphore(Short.MAX_VALUE, true);
        public final Semaphore requestRemoveSemaphore = new Semaphore(Short.MAX_VALUE, true);

        private DataSourceRequestGroup() {
        }
    }
}

