/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.level;

import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiRenderParam;
import com.seibel.distanthorizons.core.config.AppliedConfigState;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.file.fullDatafile.FullDataSourceProviderV2;
import com.seibel.distanthorizons.core.file.fullDatafile.RemoteFullDataSourceProvider;
import com.seibel.distanthorizons.core.file.structure.AbstractSaveStructure;
import com.seibel.distanthorizons.core.generation.WorldRemoteGenerationQueue;
import com.seibel.distanthorizons.core.level.AbstractDhLevel;
import com.seibel.distanthorizons.core.level.ClientLevelModule;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.level.WorldGenModule;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.multiplayer.client.ClientNetworkState;
import com.seibel.distanthorizons.core.multiplayer.client.SyncOnLoginRequestQueue;
import com.seibel.distanthorizons.core.network.event.ScopedNetworkEventSource;
import com.seibel.distanthorizons.core.network.messages.fullData.FullDataPartialUpdateMessage;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.render.RenderBufferHandler;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.render.renderer.generic.GenericObjectRenderer;
import com.seibel.distanthorizons.core.sql.dto.FullDataSourceV2DTO;
import com.seibel.distanthorizons.core.sql.repo.FullDataSourceV2Repo;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IProfilerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.awt.Color;
import java.io.File;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.CheckForNull;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class DhClientLevel
extends AbstractDhLevel
implements IDhClientLevel {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final IMinecraftClientWrapper MC_CLIENT = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    public final ClientLevelModule clientside;
    public final IClientLevelWrapper levelWrapper;
    public final AbstractSaveStructure saveStructure;
    public final RemoteFullDataSourceProvider dataFileHandler;
    @CheckForNull
    private final ClientNetworkState networkState;
    @Nullable
    private final ScopedNetworkEventSource eventSource;
    public final WorldGenModule worldGenModule;
    public final AppliedConfigState<Boolean> worldGeneratorEnabledConfig;
    @Nullable
    private final SyncOnLoginRequestQueue syncOnLoginRequestQueue;

    public DhClientLevel(AbstractSaveStructure saveStructure, IClientLevelWrapper clientLevelWrapper, @Nullable ClientNetworkState networkState) {
        this(saveStructure, clientLevelWrapper, null, true, networkState);
    }

    public DhClientLevel(AbstractSaveStructure saveStructure, IClientLevelWrapper clientLevelWrapper, @Nullable File fullDataSaveDirOverride, boolean enableRendering, @Nullable ClientNetworkState networkState) {
        if (saveStructure.getFullDataFolder(clientLevelWrapper).mkdirs()) {
            LOGGER.warn("unable to create data folder.");
        }
        this.levelWrapper = clientLevelWrapper;
        this.levelWrapper.setParentLevel(this);
        this.saveStructure = saveStructure;
        this.networkState = networkState;
        if (networkState != null) {
            this.eventSource = new ScopedNetworkEventSource(networkState.getSession());
            this.syncOnLoginRequestQueue = new SyncOnLoginRequestQueue(this, networkState);
            this.registerNetworkHandlers();
        } else {
            this.eventSource = null;
            this.syncOnLoginRequestQueue = null;
        }
        this.dataFileHandler = new RemoteFullDataSourceProvider(this, saveStructure, fullDataSaveDirOverride, this.syncOnLoginRequestQueue);
        this.worldGeneratorEnabledConfig = new AppliedConfigState<Boolean>(Config.Client.Advanced.WorldGenerator.enableDistantGeneration);
        this.worldGenModule = new WorldGenModule(this);
        this.clientside = new ClientLevelModule(this);
        this.createAndSetSupportingRepos(((FullDataSourceV2Repo)this.dataFileHandler.repo).databaseFile);
        this.runRepoReliantSetup();
        if (enableRendering) {
            this.clientside.startRenderer(clientLevelWrapper);
            LOGGER.info("Started DHLevel for " + this.levelWrapper + " with saves at " + this.saveStructure);
        }
    }

    private void registerNetworkHandlers() {
        assert (this.eventSource != null);
        assert (this.networkState != null);
        this.eventSource.registerHandler(FullDataPartialUpdateMessage.class, msg -> {
            try {
                FullDataSourceV2DTO dataSourceDto = this.networkState.decodeDataSourceAndReleaseBuffer(msg.payload);
                if (!msg.isSameLevelAs(this.levelWrapper)) {
                    return;
                }
                this.updateDataSourcesAsync(dataSourceDto.createPooledDataSource(this.levelWrapper));
            }
            catch (Exception e) {
                LOGGER.error("Error while updating full data source", (Throwable)e);
            }
        });
    }

    @Override
    public void clientTick() {
        try {
            this.clientside.clientTick();
            if (this.syncOnLoginRequestQueue != null) {
                this.syncOnLoginRequestQueue.tick(new DhBlockPos2D(MC_CLIENT.getPlayerBlockPos()));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unexpected clientTick Exception: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void doWorldGen() {
        ClientNetworkState networkState = this.networkState;
        boolean isClientUsable = false;
        boolean isAllowedDimension = false;
        if (networkState != null) {
            isClientUsable = networkState.isReady();
            isAllowedDimension = MC_CLIENT.getWrappedClientLevel() == this.levelWrapper;
        }
        boolean shouldDoWorldGen = isClientUsable && networkState.config.isDistantGenerationEnabled() && isAllowedDimension && this.clientside.isRendering();
        boolean isWorldGenRunning = this.worldGenModule.isWorldGenRunning();
        if (shouldDoWorldGen && !isWorldGenRunning) {
            this.worldGenModule.startWorldGen(this.dataFileHandler, new WorldGenState(this, networkState));
            ClientLevelModule.ClientRenderState renderState = this.clientside.ClientRenderStateRef.get();
            renderState.quadtree.leafNodeIterator().forEachRemaining(node -> this.dataFileHandler.getAsync(node.sectionPos));
        } else if (!shouldDoWorldGen && isWorldGenRunning) {
            this.worldGenModule.stopWorldGen(this.dataFileHandler);
        }
        if (this.worldGenModule.isWorldGenRunning()) {
            this.worldGenModule.worldGenTick(new DhBlockPos2D(MC_CLIENT.getPlayerBlockPos()).scale(MC_CLIENT.getWrappedClientLevel().getDimensionType().getTeleportationScale(this.getLevelWrapper().getDimensionType())));
        }
    }

    @Override
    public void render(DhApiRenderParam renderEventParam, IProfilerWrapper profiler) {
        this.clientside.render(renderEventParam, profiler);
    }

    @Override
    public void renderDeferred(DhApiRenderParam renderEventParam, IProfilerWrapper profiler) {
        this.clientside.renderDeferred(renderEventParam, profiler);
    }

    @Override
    public int computeBaseColor(DhBlockPos pos, IBiomeWrapper biome, IBlockStateWrapper block) {
        return this.levelWrapper.getBlockColor(pos, biome, block);
    }

    @Override
    public IClientLevelWrapper getClientLevelWrapper() {
        return this.levelWrapper;
    }

    @Override
    public void clearRenderCache() {
        this.clientside.clearRenderCache();
    }

    @Override
    public ILevelWrapper getLevelWrapper() {
        return this.levelWrapper;
    }

    @Override
    public CompletableFuture<Void> updateDataSourcesAsync(FullDataSourceV2 data) {
        return this.clientside.updateDataSourcesAsync(data);
    }

    @Override
    public int getMinY() {
        return this.levelWrapper.getMinHeight();
    }

    @Override
    public void addDebugMenuStringsToList(List<String> messageList) {
        String dimName = this.levelWrapper.getDimensionName();
        boolean rendering = this.clientside.isRendering();
        messageList.add("[" + dimName + "] rendering: " + (rendering ? "yes" : "no"));
        boolean migrationErrored = this.dataFileHandler.getMigrationStoppedWithError();
        if (!migrationErrored) {
            long migrationCount;
            long legacyDeletionCount = this.dataFileHandler.getLegacyDeletionCount();
            if (legacyDeletionCount > 0L) {
                messageList.add("  Migrating - Deleting #: " + legacyDeletionCount);
            }
            if ((migrationCount = this.dataFileHandler.getTotalMigrationCount()) > 0L) {
                messageList.add("  Migrating - Conversion #: " + migrationCount);
            }
        } else {
            messageList.add("  Migration Failed");
        }
        this.worldGenModule.addDebugMenuStringsToList(messageList);
        if (this.syncOnLoginRequestQueue != null) {
            assert (this.networkState != null);
            if (this.networkState.config.getSynchronizeOnLogin()) {
                this.syncOnLoginRequestQueue.addDebugMenuStringsToList(messageList);
            }
        }
    }

    @Override
    public void close() {
        if (this.worldGenModule != null) {
            this.worldGenModule.close();
        }
        if (this.eventSource != null) {
            this.eventSource.close();
        }
        this.levelWrapper.setParentLevel(null);
        this.clientside.close();
        super.close();
        this.dataFileHandler.close();
        LOGGER.info("Closed [" + DhClientLevel.class.getSimpleName() + "] for [" + this.levelWrapper + "]");
    }

    @Override
    public FullDataSourceProviderV2 getFullDataProvider() {
        return this.dataFileHandler;
    }

    @Override
    public AbstractSaveStructure getSaveStructure() {
        return this.saveStructure;
    }

    @Override
    public boolean hasSkyLight() {
        return this.levelWrapper.hasSkyLight();
    }

    @Override
    public GenericObjectRenderer getGenericRenderer() {
        return this.clientside.genericRenderer;
    }

    @Override
    public RenderBufferHandler getRenderBufferHandler() {
        ClientLevelModule.ClientRenderState renderState = this.clientside.ClientRenderStateRef.get();
        return renderState != null ? renderState.renderBufferHandler : null;
    }

    @Override
    public void onWorldGenTaskComplete(long pos) {
        DebugRenderer.makeParticle(new DebugRenderer.BoxParticle(new DebugRenderer.Box(pos, 128.0f, 156.0f, 0.09f, Color.red.darker()), 0.2, 32.0f));
        this.clientside.reloadPos(pos);
    }

    private static class WorldGenState
    extends WorldGenModule.AbstractWorldGenState {
        WorldGenState(IDhClientLevel level, ClientNetworkState networkState) {
            this.worldGenerationQueue = new WorldRemoteGenerationQueue(networkState, level);
        }
    }
}

