/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.file.fullDatafile;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiWorldGenerationStep;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.file.fullDatafile.DelayedFullDataSourceSaveCache;
import com.seibel.distanthorizons.core.file.fullDatafile.FullDataSourceProviderV2;
import com.seibel.distanthorizons.core.file.structure.AbstractSaveStructure;
import com.seibel.distanthorizons.core.generation.IFullDataSourceRetrievalQueue;
import com.seibel.distanthorizons.core.generation.tasks.IWorldGenTaskTracker;
import com.seibel.distanthorizons.core.generation.tasks.WorldGenResult;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.render.renderer.IDebugRenderable;
import com.seibel.distanthorizons.core.sql.repo.FullDataSourceV2Repo;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import com.seibel.distanthorizons.coreapi.util.BitShiftUtil;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class GeneratedFullDataSourceProvider
extends FullDataSourceProviderV2
implements IDebugRenderable {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static final int MAX_WORLD_GEN_REQUESTS_PER_THREAD = 20;
    private final AtomicReference<IFullDataSourceRetrievalQueue> worldGenQueueRef = new AtomicReference<Object>(null);
    private final ArrayList<IOnWorldGenCompleteListener> onWorldGenTaskCompleteListeners = new ArrayList();
    protected final DelayedFullDataSourceSaveCache delayedFullDataSourceSaveCache = new DelayedFullDataSourceSaveCache(this::onDataSourceSave, 5000);

    public GeneratedFullDataSourceProvider(IDhLevel level, AbstractSaveStructure saveStructure) {
        super(level, saveStructure);
    }

    public GeneratedFullDataSourceProvider(IDhLevel level, AbstractSaveStructure saveStructure, @Nullable File saveDirOverride) {
        super(level, saveStructure, saveDirOverride);
    }

    public void addWorldGenCompleteListener(IOnWorldGenCompleteListener listener) {
        this.onWorldGenTaskCompleteListeners.add(listener);
    }

    public void removeWorldGenCompleteListener(IOnWorldGenCompleteListener listener) {
        this.onWorldGenTaskCompleteListeners.remove(listener);
    }

    private void onWorldGenTaskComplete(WorldGenResult genTaskResult, Throwable exception) {
        if (exception != null) {
            if (!(exception instanceof CancellationException) && !(exception.getCause() instanceof CancellationException)) {
                LOGGER.error("Uncaught Gen Task Exception at [" + genTaskResult.pos + "], error: [" + exception.getMessage() + "].", exception);
            }
        } else {
            if (genTaskResult.success) {
                this.fireOnGenPosSuccessListeners(genTaskResult.pos);
                return;
            }
            LOGGER.debug("Gen Task Failed at " + genTaskResult.pos);
        }
        for (CompletableFuture completableFuture : genTaskResult.childFutures) {
            completableFuture.whenComplete((siblingGenTaskResult, siblingEx) -> this.onWorldGenTaskComplete((WorldGenResult)siblingGenTaskResult, (Throwable)siblingEx));
        }
    }

    private void fireOnGenPosSuccessListeners(long pos) {
        for (IOnWorldGenCompleteListener listener : this.onWorldGenTaskCompleteListeners) {
            listener.onWorldGenTaskComplete(pos);
        }
    }

    public void setWorldGenerationQueue(IFullDataSourceRetrievalQueue newWorldGenQueue) {
        boolean oldQueueExists = this.worldGenQueueRef.compareAndSet(null, newWorldGenQueue);
        LodUtil.assertTrue(oldQueueExists, "previous world gen queue is still here!");
        LOGGER.info("Set world gen queue for level [" + this.level.getLevelWrapper().getDimensionName() + "].");
    }

    @Override
    public boolean canRetrieveMissingDataSources() {
        return true;
    }

    @Override
    public void setTotalRetrievalPositionCount(int newCount) {
        IFullDataSourceRetrievalQueue worldGenQueue = this.worldGenQueueRef.get();
        if (worldGenQueue != null) {
            worldGenQueue.setEstimatedTotalTaskCount(newCount);
        }
    }

    @Override
    public boolean canQueueRetrieval() {
        if (!super.canQueueRetrieval()) {
            return false;
        }
        IFullDataSourceRetrievalQueue worldGenQueue = this.worldGenQueueRef.get();
        if (worldGenQueue == null) {
            return false;
        }
        ThreadPoolExecutor updateExecutor = ThreadPoolUtil.getUpdatePropagatorExecutor();
        if (updateExecutor == null || updateExecutor.getQueue().size() >= MAX_UPDATE_TASK_COUNT / 2) {
            return false;
        }
        ThreadPoolExecutor fileExecutor = ThreadPoolUtil.getFileHandlerExecutor();
        if (fileExecutor == null || fileExecutor.getQueue().size() >= MAX_UPDATE_TASK_COUNT / 2) {
            return false;
        }
        int maxQueueCount = 20 * Config.Client.Advanced.MultiThreading.numberOfWorldGenerationThreads.get();
        if (this.delayedFullDataSourceSaveCache.getUnsavedCount() >= maxQueueCount) {
            return false;
        }
        return worldGenQueue.getWaitingTaskCount() < maxQueueCount;
    }

    @Override
    public boolean queuePositionForRetrieval(Long genPos) {
        IFullDataSourceRetrievalQueue worldGenQueue = this.worldGenQueueRef.get();
        if (worldGenQueue == null) {
            return false;
        }
        GenTask genTask = new GenTask(genPos);
        CompletableFuture<WorldGenResult> worldGenFuture = worldGenQueue.submitGenTask(genPos, (byte)(DhSectionPos.getDetailLevel(genPos) - 6), genTask);
        worldGenFuture.whenComplete((genTaskResult, ex) -> this.onWorldGenTaskComplete((WorldGenResult)genTaskResult, (Throwable)ex));
        return true;
    }

    @Override
    public void removeRetrievalRequestIf(DhSectionPos.ICancelablePrimitiveLongConsumer removeIf) {
        IFullDataSourceRetrievalQueue worldGenQueue = this.worldGenQueueRef.get();
        if (worldGenQueue != null) {
            worldGenQueue.removeRetrievalRequestIf(removeIf);
        }
    }

    @Override
    public void clearRetrievalQueue() {
        this.worldGenQueueRef.set(null);
    }

    @Override
    public int getUnsavedDataSourceCount() {
        return this.delayedFullDataSourceSaveCache.getUnsavedCount();
    }

    public boolean isFullyGenerated(byte[] columnGenerationSteps) {
        return IntStream.range(0, columnGenerationSteps.length).noneMatch(i -> columnGenerationSteps[i] == EDhApiWorldGenerationStep.EMPTY.value);
    }

    @Override
    public LongArrayList getPositionsToRetrieve(Long pos) {
        byte[] columnGenerationSteps;
        IFullDataSourceRetrievalQueue worldGenQueue = this.worldGenQueueRef.get();
        if (worldGenQueue == null) {
            return null;
        }
        if (((FullDataSourceV2Repo)this.repo).existsWithKey(pos) && (columnGenerationSteps = ((FullDataSourceV2Repo)this.repo).getColumnGenerationStepForPos(pos)) != null) {
            boolean positionFullyGenerated = true;
            for (int i = 0; i < columnGenerationSteps.length; ++i) {
                if (columnGenerationSteps[i] != EDhApiWorldGenerationStep.EMPTY.value) continue;
                positionFullyGenerated = false;
                break;
            }
            if (positionFullyGenerated) {
                return new LongArrayList();
            }
        }
        LongArrayList generationList = new LongArrayList();
        byte minGeneratorSectionDetailLevel = (byte)(worldGenQueue.highestDataDetail() + 6);
        DhSectionPos.forEachChildAtDetailLevel(pos, minGeneratorSectionDetailLevel, genPos -> {
            if (!((FullDataSourceV2Repo)this.repo).existsWithKey(genPos)) {
                generationList.add(genPos);
            } else {
                byte[] columnGenerationSteps = ((FullDataSourceV2Repo)this.repo).getColumnGenerationStepForPos(genPos);
                if (columnGenerationSteps == null) {
                    return;
                }
                EDhApiWorldGenerationStep currentMinWorldGenStep = EDhApiWorldGenerationStep.LIGHT;
                block0: for (int x = 0; x < 64; ++x) {
                    for (int z = 0; z < 64; ++z) {
                        EDhApiWorldGenerationStep newWorldGenStep;
                        int index = FullDataSourceV2.relativePosToIndex(x, z);
                        byte genStepValue = columnGenerationSteps[index];
                        if (genStepValue < currentMinWorldGenStep.value && (newWorldGenStep = EDhApiWorldGenerationStep.fromValue(genStepValue)) != null && newWorldGenStep.value < currentMinWorldGenStep.value) {
                            currentMinWorldGenStep = newWorldGenStep;
                        }
                        if (currentMinWorldGenStep == EDhApiWorldGenerationStep.EMPTY) break block0;
                    }
                }
                if (currentMinWorldGenStep != EDhApiWorldGenerationStep.EMPTY) {
                    return;
                }
                generationList.add(genPos);
            }
        });
        return generationList;
    }

    @Override
    public int getMaxPossibleRetrievalPositionCountForPos(Long pos) {
        IFullDataSourceRetrievalQueue worldGenQueue = this.worldGenQueueRef.get();
        if (worldGenQueue == null) {
            return -1;
        }
        int minGeneratorSectionDetailLevel = worldGenQueue.highestDataDetail() + 6;
        int detailLevelDiff = DhSectionPos.getDetailLevel(pos) - minGeneratorSectionDetailLevel;
        return BitShiftUtil.powerOfTwo(detailLevelDiff);
    }

    public Map<Long, Integer> getLoadStates(Iterable<Long> posList) {
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        for (long pos : posList) {
            map.put(pos, this.delayedFullDataSourceSaveCache.dataSourceByPosition.containsKey(pos) ? 3 : (this.fileExists(pos) ? 2 : 1));
        }
        return map;
    }

    @Override
    public void debugRender(DebugRenderer renderer) {
        super.debugRender(renderer);
        this.delayedFullDataSourceSaveCache.dataSourceByPosition.forEach((pos, dataSource) -> renderer.renderBox(new DebugRenderer.Box((long)pos, -32.0f, 80.0f, 0.2f, Color.green.darker())));
    }

    private void onDataSourceSave(FullDataSourceV2 fullDataSource) {
        this.updateDataSourceAsync(fullDataSource);
    }

    @FunctionalInterface
    public static interface IOnWorldGenCompleteListener {
        public void onWorldGenTaskComplete(long var1);
    }

    private class GenTask
    implements IWorldGenTaskTracker {
        private final long pos;

        public GenTask(long pos) {
            this.pos = pos;
        }

        @Override
        public boolean isMemoryAddressValid() {
            return true;
        }

        @Override
        public Consumer<FullDataSourceV2> getChunkDataConsumer() {
            return chunkSizedFullDataSource -> GeneratedFullDataSourceProvider.this.delayedFullDataSourceSaveCache.queueDataSourceForUpdateAndSave((FullDataSourceV2)chunkSizedFullDataSource);
        }
    }
}

