/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.config.file;

import DistantHorizons.libraries.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.seibel.distanthorizons.core.config.ConfigBase;
import com.seibel.distanthorizons.core.config.file.ConfigTypeConverters;
import com.seibel.distanthorizons.core.config.types.AbstractConfigType;
import com.seibel.distanthorizons.core.config.types.ConfigEntry;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftSharedWrapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigFileHandling {
    public final ConfigBase configBase;
    public final Path configPath;
    private final Logger LOGGER;
    private final CommentedFileConfig nightConfig;

    public ConfigFileHandling(ConfigBase configBase, Path configPath) {
        this.LOGGER = LogManager.getLogger((String)(this.getClass().getSimpleName() + ", " + configBase.modID));
        this.configBase = configBase;
        this.configPath = configPath;
        this.nightConfig = (CommentedFileConfig)CommentedFileConfig.builder(this.configPath.toFile()).build();
    }

    public void saveToFile() {
        this.saveToFile(this.nightConfig);
    }

    public void saveToFile(CommentedFileConfig nightConfig) {
        if (!Files.exists(this.configPath, new LinkOption[0])) {
            ConfigFileHandling.reCreateFile(this.configPath);
        }
        this.loadNightConfig(nightConfig);
        for (AbstractConfigType<?, ?> entry : this.configBase.entries) {
            if (!ConfigEntry.class.isAssignableFrom(entry.getClass())) continue;
            this.createComment((ConfigEntry)entry, nightConfig);
            this.saveEntry((ConfigEntry)entry, nightConfig);
        }
        try {
            nightConfig.save();
        }
        catch (Exception e) {
            SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class).crashMinecraft("Failed to save config at [" + this.configPath.toString() + "]", e);
        }
    }

    public void loadFromFile() {
        int currentCfgVersion = this.configBase.configVersion;
        try {
            CommentedFileConfig tmpNightConfig = (CommentedFileConfig)CommentedFileConfig.builder(this.configPath.toFile()).build();
            tmpNightConfig.load();
            currentCfgVersion = (Integer)tmpNightConfig.get("_version");
            tmpNightConfig.close();
        }
        catch (Exception tmpNightConfig) {
            // empty catch block
        }
        if (currentCfgVersion != this.configBase.configVersion) {
            if (currentCfgVersion > this.configBase.configVersion) {
                this.LOGGER.warn("Found config version [" + String.valueOf(currentCfgVersion) + "] which is newer than current mods config version of [" + String.valueOf(this.configBase.configVersion) + "]. You may have downgraded the mod and items may have been moved, you have been warned");
            } else {
                this.LOGGER.warn(this.configBase.modName + " config is of an older version, currently there is no config updater... so resetting config");
                try {
                    Files.delete(this.configPath);
                }
                catch (Exception e) {
                    this.LOGGER.error((Object)e);
                }
            }
        }
        this.loadFromFile(this.nightConfig);
        this.nightConfig.set("_version", (Object)this.configBase.configVersion);
    }

    public void loadFromFile(CommentedFileConfig nightConfig) {
        if (Files.exists(this.configPath, new LinkOption[0])) {
            this.loadNightConfig(nightConfig);
        } else {
            ConfigFileHandling.reCreateFile(this.configPath);
        }
        for (AbstractConfigType<?, ?> entry : this.configBase.entries) {
            if (!ConfigEntry.class.isAssignableFrom(entry.getClass()) || !entry.getAppearance().showInFile) continue;
            this.createComment((ConfigEntry)entry, nightConfig);
            this.loadEntry((ConfigEntry)entry, nightConfig);
        }
        try {
            nightConfig.save();
        }
        catch (Exception e) {
            SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class).crashMinecraft("Failed to save config at [" + this.configPath.toString() + "]", e);
        }
    }

    public void saveEntry(ConfigEntry<?> entry) {
        this.saveEntry(entry, this.nightConfig);
        this.nightConfig.save();
    }

    public void saveEntry(ConfigEntry<?> entry, CommentedFileConfig workConfig) {
        if (!entry.getAppearance().showInFile) {
            return;
        }
        if (SingletonInjector.INSTANCE.get(IMinecraftSharedWrapper.class).isDedicatedServer() && entry.getServersideShortName() == null) {
            return;
        }
        if (entry.getTrueValue() == null) {
            throw new IllegalArgumentException("Entry [" + entry.getNameWCategory() + "] is null, this may be a problem with [" + this.configBase.modName + "]. Please contact the authors");
        }
        workConfig.set(entry.getNameWCategory(), ConfigTypeConverters.attemptToConvertToString(entry.getType(), entry.getTrueValue()));
    }

    public void loadEntry(ConfigEntry<?> entry) {
        this.loadEntry(entry, this.nightConfig);
    }

    public <T> void loadEntry(ConfigEntry<T> entry, CommentedFileConfig nightConfig) {
        if (!entry.getAppearance().showInFile) {
            return;
        }
        if (!nightConfig.contains(entry.getNameWCategory())) {
            this.saveEntry(entry, nightConfig);
            return;
        }
        try {
            Object value;
            if (entry.getType().isEnum()) {
                entry.pureSet(nightConfig.getEnum(entry.getNameWCategory(), entry.getType()));
                return;
            }
            Class<?> expectedValueClass = entry.getType();
            Object convertedValue = ConfigTypeConverters.attemptToConvertFromString(expectedValueClass, value = nightConfig.get(entry.getNameWCategory()));
            if (!convertedValue.getClass().equals(expectedValueClass)) {
                this.LOGGER.error("Unable to convert config value [" + value + "] from [" + (value != null ? value.getClass() : "NULL") + "] to [" + expectedValueClass + "] for config [" + entry.name + "], the default config value will be used instead [" + entry.getDefaultValue() + "]. Make sure a converter is defined in [" + ConfigTypeConverters.class.getSimpleName() + "].");
                convertedValue = entry.getDefaultValue();
            }
            entry.pureSet(convertedValue);
            if (entry.getTrueValue() == null) {
                this.LOGGER.warn("Entry [" + entry.getNameWCategory() + "] returned as null from the config. Using default value.");
                entry.pureSet(entry.getDefaultValue());
            }
        }
        catch (Exception e) {
            this.LOGGER.warn("Entry [" + entry.getNameWCategory() + "] had an invalid value when loading the config. Using default value.");
            entry.pureSet(entry.getDefaultValue());
        }
    }

    public void createComment(ConfigEntry<?> entry) {
        this.createComment(entry, this.nightConfig);
    }

    public void createComment(ConfigEntry<?> entry, CommentedFileConfig nightConfig) {
        if (!entry.getAppearance().showInFile || entry.getComment() == null) {
            return;
        }
        if (SingletonInjector.INSTANCE.get(IMinecraftSharedWrapper.class).isDedicatedServer() && entry.getServersideShortName() == null) {
            return;
        }
        String comment = entry.getComment().replaceAll("\n", "\n ").trim();
        comment = "\n " + comment;
        nightConfig.setComment(entry.getNameWCategory(), comment);
    }

    public void loadNightConfig() {
        this.loadNightConfig(this.nightConfig);
    }

    public void loadNightConfig(CommentedFileConfig nightConfig) {
        try {
            try {
                if (!Files.exists(this.configPath, new LinkOption[0])) {
                    Files.createFile(this.configPath, new FileAttribute[0]);
                }
                nightConfig.load();
            }
            catch (Exception e) {
                this.LOGGER.warn("Loading file failed because of this expectation:\n" + e);
                ConfigFileHandling.reCreateFile(this.configPath);
                nightConfig.load();
            }
        }
        catch (Exception ex) {
            System.out.println("Creating file failed");
            this.LOGGER.error((Object)ex);
            SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class).crashMinecraft("Loading file and resetting config file failed at path [" + this.configPath + "]. Please check the file is ok and you have the permissions", ex);
        }
    }

    public static void reCreateFile(Path path) {
        try {
            Files.deleteIfExists(path);
            if (!path.getParent().toFile().exists()) {
                Files.createDirectory(path.getParent(), new FileAttribute[0]);
            }
            Files.createFile(path, new FileAttribute[0]);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

