/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.api.internal;

import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiLevelLoadEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiLevelUnloadEvent;
import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.network.messages.NetworkMessage;
import com.seibel.distanthorizons.core.world.AbstractDhWorld;
import com.seibel.distanthorizons.core.world.DhClientServerWorld;
import com.seibel.distanthorizons.core.world.DhServerWorld;
import com.seibel.distanthorizons.core.world.IDhServerWorld;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.IServerPlayerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import com.seibel.distanthorizons.coreapi.DependencyInjection.ApiEventInjector;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ServerApi {
    public static final ServerApi INSTANCE = new ServerApi();
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();

    private ServerApi() {
    }

    public void serverTickEvent() {
        try {
            IDhServerWorld serverWorld = SharedApi.getIDhServerWorld();
            if (serverWorld != null) {
                serverWorld.serverTick();
                SharedApi.worldGenTick(serverWorld::doWorldGen);
            }
        }
        catch (Exception e) {
            LOGGER.error("ServerTickEvent error: " + e.getMessage(), (Throwable)e);
        }
    }

    public void serverLoadEvent(boolean isDedicatedEnvironment) {
        LOGGER.debug("Server World loading with (dedicated?:" + isDedicatedEnvironment + ")");
        SharedApi.setDhWorld(isDedicatedEnvironment ? new DhServerWorld() : new DhClientServerWorld());
    }

    public void serverUnloadEvent() {
        LOGGER.debug("Server World " + SharedApi.getAbstractDhWorld() + " unloading");
        AbstractDhWorld dhWorld = SharedApi.getAbstractDhWorld();
        if (dhWorld != null) {
            dhWorld.close();
            SharedApi.setDhWorld(null);
        }
    }

    public void serverLevelLoadEvent(IServerLevelWrapper level) {
        LOGGER.debug("Server Level " + level + " loading");
        AbstractDhWorld serverWorld = SharedApi.getAbstractDhWorld();
        if (serverWorld != null) {
            serverWorld.getOrLoadLevel(level);
            ApiEventInjector.INSTANCE.fireAllEvents(DhApiLevelLoadEvent.class, new DhApiLevelLoadEvent.EventParam(level));
        }
    }

    public void serverLevelUnloadEvent(IServerLevelWrapper level) {
        LOGGER.debug("Server Level " + level + " unloading");
        AbstractDhWorld serverWorld = SharedApi.getAbstractDhWorld();
        if (serverWorld != null) {
            serverWorld.unloadLevel(level);
            ApiEventInjector.INSTANCE.fireAllEvents(DhApiLevelUnloadEvent.class, new DhApiLevelUnloadEvent.EventParam(level));
        }
    }

    public void serverChunkLoadEvent(IChunkWrapper chunkWrapper, ILevelWrapper level) {
        SharedApi.INSTANCE.applyChunkUpdate(chunkWrapper, level, false);
    }

    public void serverChunkSaveEvent(IChunkWrapper chunkWrapper, ILevelWrapper level) {
        SharedApi.INSTANCE.applyChunkUpdate(chunkWrapper, level, true);
    }

    public void serverPlayerJoinEvent(IServerPlayerWrapper player) {
        IDhServerWorld serverWorld = SharedApi.getIDhServerWorld();
        if (serverWorld instanceof DhServerWorld) {
            LOGGER.info("Creating state for player: " + player.getName());
            ((DhServerWorld)serverWorld).addPlayer(player);
        }
    }

    public void serverPlayerDisconnectEvent(IServerPlayerWrapper player) {
        IDhServerWorld serverWorld = SharedApi.getIDhServerWorld();
        if (serverWorld instanceof DhServerWorld) {
            LOGGER.info("Destroying state for player: " + player.getName());
            ((DhServerWorld)serverWorld).removePlayer(player);
        }
    }

    public void serverPlayerLevelChangeEvent(IServerPlayerWrapper player, IServerLevelWrapper origin, IServerLevelWrapper dest) {
        IDhServerWorld serverWorld = SharedApi.getIDhServerWorld();
        if (serverWorld instanceof DhServerWorld) {
            LOGGER.info("Player changed level: " + player.getName());
            ((DhServerWorld)serverWorld).changePlayerLevel(player, origin, dest);
        }
    }

    public void pluginMessageReceived(IServerPlayerWrapper player, @NotNull NetworkMessage message) {
        IDhServerWorld serverWorld = SharedApi.getIDhServerWorld();
        if (serverWorld instanceof DhServerWorld) {
            ((DhServerWorld)serverWorld).remotePlayerConnectionHandler.handlePluginMessage(player, message);
        }
    }
}

