/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core;

import DistantHorizons.libraries.electronwill.nightconfig.core.Config;
import DistantHorizons.libraries.jpountz.lz4.LZ4FrameOutputStream;
import com.seibel.distanthorizons.api.DhApi;
import com.seibel.distanthorizons.core.api.external.methods.config.DhApiConfig;
import com.seibel.distanthorizons.core.api.external.methods.data.DhApiTerrainDataRepo;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.render.DhApiRenderProxy;
import com.seibel.distanthorizons.core.render.renderer.generic.GenericRenderObjectFactory;
import com.seibel.distanthorizons.core.sql.DatabaseUpdater;
import com.seibel.distanthorizons.core.world.DhApiWorldProxy;
import com.seibel.distanthorizons.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.awt.GraphicsEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.tukaani.xz.XZOutputStream;

public class Initializer {
    private static final Logger LOGGER = LogManager.getLogger((String)("DistantHorizons-" + Initializer.class.getSimpleName()));

    public static void init() {
        try {
            Class<LZ4FrameOutputStream> fastCompressor = LZ4FrameOutputStream.class;
            Class<XZOutputStream> smallCompressor = XZOutputStream.class;
            Class<Config> config = Config.class;
            Class<LongArrayList> clazz = LongArrayList.class;
        }
        catch (Throwable e) {
            LOGGER.fatal("Critical programmer error: One or more libraries aren't present. Error: [" + e.getMessage() + "].");
            throw e;
        }
        try {
            int scriptCount = DatabaseUpdater.getAutoUpdateScriptCount();
            if (scriptCount == 0) {
                throw new NullPointerException("No auto update scripts found, but no error thrown. This might mean the script list file is corrupted or empty.");
            }
        }
        catch (Exception e) {
            LOGGER.fatal("Critical programmer error: Can't read SQL Scripts resource folder is either missing or malformed. Error: [" + e.getMessage() + "].");
            throw new RuntimeException(e);
        }
        if (SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class) != null) {
            System.setProperty("java.awt.headless", "false");
            if (GraphicsEnvironment.isHeadless()) {
                LOGGER.warn("Java.awt.headless is false. This means Distant Horizons can't display error and info dialog windows.");
            } else {
                LOGGER.info("Java.awt.headless set to true. Distant Horizons can correctly display error and info dialog windows.");
            }
        }
        DhApi.Delayed.configs = DhApiConfig.INSTANCE;
        DhApi.Delayed.terrainRepo = DhApiTerrainDataRepo.INSTANCE;
        DhApi.Delayed.worldProxy = DhApiWorldProxy.INSTANCE;
        DhApi.Delayed.renderProxy = DhApiRenderProxy.INSTANCE;
        DhApi.Delayed.customRenderObjectFactory = GenericRenderObjectFactory.INSTANCE;
        DhApi.Delayed.wrapperFactory = SingletonInjector.INSTANCE.get(IWrapperFactory.class);
        if (DhApi.Delayed.wrapperFactory == null) {
            LOGGER.error("Programmer Error: No [" + IWrapperFactory.class.getSimpleName() + "] assigned to the DhApi.");
        }
    }
}

